class PopupPage < CGIKit::Component
	TEST_LIST = ['Ruby', 'Smalltalk', 'Java', 'Prolog', 'Objective-C']
	TEST_LIST_FOR_ESCAPE = ['&TestEscapeForPopupPage&']
	TEST_ITEM = :item
	TEST_DISPLAY = :"#{TEST_ITEM}.upcase"
	TEST_DEFAULT = 'DefalutValue'
	TEST_VALUE = :"#{TEST_ITEM}.object_id"
	TEST_SELECTION = :selection
	TEST_SELECTED_VALUE = :selected_value

	TEST_LIST_AND_ITEM_NAME = 'TestListAndItem'
	TEST_DISPLAY_NAME = 'TestDisplay'
	TEST_DEFAULT_NAME = 'TestDefault'
	TEST_VALUE_NAME = 'TestValue'
	TEST_ESCAPE_NAME = 'TestEscape'
	TEST_SELECTION_WITH_INDEX_NAME = 'TestSelectionWithIndex'
	TEST_SELECTION_WITH_VALUE_NAME = 'TestSelectionWithValue'
	TEST_SELECTED_VALUE_WITH_INDEX_NAME = 'TestSelectedValueWithIndex'
	TEST_SELECTED_VALUE_WITH_VALUE_NAME = 'TestSelectedValueWithValue'
	TEST_ENABLED_NAME = 'TestEnabled'

	def self.test_list_and_item( command )
		select = command.element(TEST_LIST_AND_ITEM_NAME)
		select.options.each_with_index do |option, index|
			unless TEST_LIST[index].to_s == option.content then
				return false
			end
		end
		true
	end

	def self.test_display( command )
		select = command.element(TEST_DISPLAY_NAME)
		select.options.each_with_index do |option, index|
			unless TEST_LIST[index].upcase == option.content then
				return false
			end
		end
		true
	end

	def self.test_default( command )
		select = command.element(TEST_DEFAULT_NAME)
		default = select.options[0]
		(default.selected? and (default.content == TEST_DEFAULT))
	end

	def self.test_escape( command )
		select = command.element(TEST_ESCAPE_NAME)
		select.options.each_with_index do |option, index|
			if TEST_LIST_FOR_ESCAPE[index].to_s != option.content then
				return true
			end
		end
		false
	end

	def self.test_value( command )
		select = command.element(TEST_VALUE_NAME)
		select.options.each_with_index do |option, index|
			unless TEST_LIST[index].object_id.to_s == option[:value] then
				return false
			end
		end
		true
	end

end
