module CGIKit

  module RSS

    class ActionURL

      class << self
        def create_api
          api = API.new(:ActionURL)
          api << Binding.new(:rss_action)
          api << Binding.new(:rss_class)
          api << required_validation([], [], [:rss_action, :rss_class])
          api
        end
      end

      def begin_context( context )
        context.increment
      end

      def end_context( context ); end

      def append_to_response( response, context )
        take_value(:rss_action, false)
        take_value(:rss_class)
        response.content << context.rss_action_url(@values[:rss_class],
                                                   @values[:rss_action])
      end

    end

  end

end

