module CGIKit::Project

  class CGIScriptTemplate < ScriptTemplate

    def template_ja
      <<EOF
#!#{@project.ruby_path}

$LOAD_PATH.unshift('lib')
require 'cgikit'
require 'cgikit/lang/ja'
require 'cgikit/rss'
require 'cgikit/ajax'
require 'application'
require 'session'
require 'directaction'
require 'rssaction'
require 'ajaxaction'

app = #{@project.application.class_name}.new
app.autoload_all_components('#{ComponentTemplate::COMPONENT_LIB}', #{@project.name})
app.load_configuration('#{ConfigurationTemplate::CONF_FILE}')
app.run
EOF
    end

  end

end

