module CGIKit::Project

  class FastCGIScriptTemplate < ScriptTemplate

    def template_en
      <<EOF
#!#{@project.ruby_path}

current = File::dirname(File::expand_path(__FILE__))
$:.unshift(current)
Dir.chdir(current)

$LOAD_PATH.unshift('lib')
require 'cgikit'
require 'cgikit/fastcgi'
require 'cgikit/rss'
require 'cgikit/ajax'
require 'application'
require 'session'
require 'directaction'
require 'rssaction'
require 'ajaxaction'

app = #{@project.application.class_name}.new
app.adapter_class = CGIKit::Adapter::FastCGI
app.session_store_class = CGIKit::FileSessionStore
app.template_store_class = CGIKit::FileTemplateStore
app.resource_store_class = CGIKit::MemoryResourceStore
app.load_configuration('#{ConfigurationTemplate::CONF_FILE}')

FCGI.each do |req|
  app.run(req)
end
EOF
    end

  end

end
