module CGIKit; end

require 'cgikit/project/template'
require 'cgikit/project/templates/ja/application'
require 'cgikit/project/templates/ja/session'
require 'cgikit/project/templates/ja/directaction'
require 'cgikit/project/templates/ja/rssaction'
require 'cgikit/project/templates/ja/ajaxaction'
require 'cgikit/project/templates/ja/component'
require 'cgikit/project/templates/ja/conf'
require 'cgikit/project/templates/ja/cgi'
require 'cgikit/project/templates/ja/webrick'
require 'cgikit/project/templates/ja/modruby'
require 'cgikit/project/templates/ja/fastcgi'
require 'cgikit/project/templates/en/application'
require 'cgikit/project/templates/en/session'
require 'cgikit/project/templates/en/directaction'
require 'cgikit/project/templates/en/rssaction'
require 'cgikit/project/templates/en/ajaxaction'
require 'cgikit/project/templates/en/component'
require 'cgikit/project/templates/en/conf'
require 'cgikit/project/templates/en/cgi'
require 'cgikit/project/templates/en/webrick'
require 'cgikit/project/templates/en/modruby'
require 'cgikit/project/templates/en/fastcgi'
require 'fileutils'

module CGIKit::Project

  class Project

    DEFAULT_PAGE = 'MainPage'

    attr_accessor :name, :application, :session, :direct_action, :components, \
    :project_dir, :lib_dir, :component_dir, :ruby_path, :scripts, :japanese, \
    :conf, :resource

    def initialize( path = nil )
      if path then
        @name = File.basename(path)
        @project_dir = File.dirname(path)
      else
        @project_dir = '.'
      end
      @ruby_path = %x(which ruby).chomp
      @lib_dir = 'lib'
      @component_dir = 'components'
      @application = ApplicationTemplate.new(self)
      @session = SessionTemplate.new(self)
      @direct_action = DirectActionTemplate.new(self)
      @rss_action = RSSActionTemplate.new(self)
      @ajax_action = AjaxActionTemplate.new(self)
      @components = [ComponentTemplate.new(self, DEFAULT_PAGE)]
      @scripts = []
      @scripts << CGIScriptTemplate.new(self)
      @scripts << ModRubyScriptTemplate.new(self)
      @scripts << WEBrickScriptTemplate.new(self)
      @scripts << FastCGIScriptTemplate.new(self)
      @conf = ConfigurationTemplate.new(self)
      @resource = ResourceTemplate.new(self)
      @web_server_resource = WebServerResourceTemplate.new(self)
      @package = PackageTemplate.new(self)
    end

    def japanese?
      @japanese
    end

    def add_component( name )
      @components << ComponentTemplate.new(self, name)
    end

    def project_path
      File.join(@project_dir, @name)
    end

    def lib_path
      File.join(@project_dir, @name, @lib_dir)
    end

    def component_path
      File.join(@project_dir, @name, @component_dir)
    end

    def write
      begin
        FileUtils.makedirs(lib_path)
        FileUtils.makedirs(component_path)
        @application.write
        @session.write
        @direct_action.write
        @rss_action.write
        @ajax_action.write
        @components.each do |c| c.write end
        @scripts.each do |s| s.write end
        @conf.write
        @resource.write
        @web_server_resource.write
        @package.write
      rescue Exception => e
        FileUtils.rm_rf(project_path())
        raise e
      end
    end

  end

end
