require 'rbconfig'

module CGIKit
  
  module Command
    
    class Dispatcher
      def initialize
      end
      
      def command_list
        arr = []
        
        
        #ObjectSpace.each_object(Class) do |klass|
        #  if klass < CGIKit::Command::Base and not(klass.const_defined?(:NOT_COMMAND))
        #    arr << klass.to_s.split('::').last.downcase
        #  end
        #end
        CGIKit::Command.constants.each do |const|
          obj = CGIKit::Command.const_get(const)
          if (Class === obj) and (obj < CGIKit::Command::Base) and not(obj.const_defined?(:NOT_COMMAND))
            arr << obj.to_s.split('::').last.downcase
          end
        end
        
        arr
      end
      
      def command?(name)
        command_list.include?(name)
      end
      
      def dispatch(argv)
        cmd = argv.shift
        if command?(cmd)
          require 'cgikit'
          
          obj = CGIKit::Command.const_get(cmd.capitalize).new          
          obj.setup
          obj.execute(argv)
          obj.teardown
        else
          print "Usage: #{$0} command [options]\n\n"
          print "Available commands: \n"
          command_list.sort.each do |i|
            print '    ', i, "\n" 
          end
        end
      end
      
    end  # end of Dispatcher
    
    class Base
      
      def show_usage(s)
        print(s)
        exit
      end
      
      def show_error(s)
        print(s)
        exit(1)
      end
      
      def default_ruby_path
        ruby = File.join(Config::CONFIG['bindir'], Config::CONFIG['ruby_install_name'])
        if FileTest::file?(ruby) and FileTest::executable?(ruby)
          return ruby
        end
        
        begin
          %x(which ruby).chomp
        rescue Exception => e
          # for windows
          paths = ENV['PATH'].split(':')
          exts = ['', '.com', '.exe', '.bat', '.cmd', '.vbs', '.js', '.wsf']
          paths.each do |path|
            exts.each do |ext|
              command = File.join(path, "ruby#{ext}")
              if FileTest.exist?(command) then
                return command
              end
            end
          end
          raise "Can't find ruby"
        end
      end
      
      def setup
      end
      
      def teardown
      end
        
    end  # end of CGIKit::Command::Base     
    
    
    
    class Parse < Base
      
      def execute(opts)
        require 'pp'
        
        if opts.size == 0
          show_usage("parse: No Input File\nUsage: #{$0} parse filename")
        elsif opts.size != 1
          show_usage("parse: Number of argument must be one.\n    #{opts.inspect}")
        end
        
        parser = CGIKit::HTMLParser::HTMLParser.new(opts[0])
        pp parser.node
      end 
      
    end
    
    
    
    class Sweep < Base
      
      USAGE = "Usage: #{$0} sweep [-d key] uri [password]"
      SWEEP_NOT_AVAILABLE = "#{$0} sweep: %s: not sweep page"
      
      SWEEP = '__sweep_sessions'
      KEY = 'd'
      
      def execute(opts)
        require 'optparse'
        require 'uri'
        require 'net/http'
        
        key = KEY
        opt = OptionParser.new
        opt.on("-d [key]", "DirectAction request handler key") do |v| key = v end      
        begin
          opt.parse!(opts)
        rescue
          show_usage(USAGE)
        end
        
        uri = opts.shift
        pass = opts.shift
        
        show_usage(USAGE) if uri.nil?
        
        
        
        uri.gsub!(/\/\Z/, '')
        uri = "http://#{uri}" unless /\Ahttp:\/\// === uri
        uri = "#{uri}/#{KEY}/#{SWEEP}"
        uri = URI.parse(uri)
        
        Net::HTTP.version_1_2 
        Net::HTTP.start(uri.host, uri.port) do |http|
          response = http.get(uri.path)
          unless CGIKit::DirectAction.sweep_page?(response.body) then
            show_error(SWEEP_NOT_AVAILABLE  % uri.to_s)
          end
        end
        
        unless pass then
          system 'stty -echo'
          print "Password: "
          pass = gets.chomp
          system 'stty echo'
          puts
        end
        
        Net::HTTP.start(uri.host, uri.port) do |http|
          response = http.post(uri.path,
          "#{CGIKit::DirectAction::SWEEP_PASS_KEY}=#{pass}")
          successed, failed = CGIKit::DirectAction.sweep_info(response.body)
          puts "Deleted: #{successed}"
          puts "Failed:  #{failed}"
        end              
      end
    end
    
    
    
      
    class TemplateGenerator < Base
      
      NOT_COMMAND = true
      
      def setup
        require 'cgikit/project/project'
        require 'optparse'
        
        @opt = OptionParser.new
        @opt.on("--ruby [#{default_ruby_path}]", "Path to ruby"){|v| @rubypath = v}
        @opt.on("--ja", "Change language to Japanese"){|v| @ja = v} 
      end
      
      def execute(opts)
        raise StandardError, "Not Implemented"
      end
      
    end
    
    
    class Project < TemplateGenerator
      
      USAGE = "Usage: #{$0} project [options] apppath"
      
      def execute(opts)
        begin
          @opt.parse!(opts)
        rescue StandardError => e
          show_usage(USAGE + "\n" + e.message )
        end
        
        ja = @ja
        rubypath = @rubypath || default_ruby_path()
        apppath = opts.shift
        show_usage(USAGE) unless apppath
        
        project = CGIKit::Project::Project.new(apppath)
        project.japanese = ja if ja
        project.ruby_path = rubypath if rubypath
        project.write          
      end
    end
    
    
    
    class Component < TemplateGenerator
      USAGE = "Usage: #{$0} component [options] classname"
      
      def setup
        super()
        
        @opt.on("-s superclass", "Create subclass of the specified class") do |v|
          @superclassname = v
        end
      end
      
      def execute(opts)
        begin
          @opt.parse!(opts)
        rescue StandardError => e
          show_usage(USAGE + "\n" + e.message )
        end
        
        classname = opts.pop
        if classname.nil? then
          show_usage(USAGE)
        end
        ja = @ja
        superclassname = @superclassname
        
        begin
          project = CGIKit::Project::Project.new
          project.japanese = ja if ja
          comp = CGIKit::Project::ComponentTemplate.new(project, classname, superclassname)
          comp.write
        rescue Exception => e
          show_error(e.message)
        end
      end        
    end
    
    
    
    class Package < TemplateGenerator            
      USAGE = "Usage: #{$0} package path"
      
      def setup
        super()
        require 'cgikit/project/package'
      end
      
      def execute(opts)        
        path = opts.shift
        show_usage(USAGE) unless path
        
        pkg = CGIKit::Project::PackageGenerator.new(path)
        pkg.write
      end
    end
    
  end
  
end

