module CGIKit

# The super class of HTTP Request-Response classes.
class Message
  # HTML content.
  attr_accessor :content

  # Hash of HTTP headers.
  attr_accessor :headers

  # HTTP version. The default value is "1.1".
  attr_accessor :http_version

  # The encoding used for the content.
  attr_accessor :encoding

  # Array of Cookie objects.
  attr_accessor :cookies

  EOL = "\r\n"

  def initialize( headers = nil )
    @headers      = headers || {}
    @http_version = "1.1"
    @cookies      = []
    @content      = ''
  end

  # Adds a cookie object.
  def add_cookie( cookie )
    @cookies << cookie
  end

  # Removes the specified cookie in the cookies.
  def remove_cookie( cookie )
    @cookies.delete cookie
  end

  # Returns HTTP version.
  def http_version_line
    "HTTP/#@http_version"
  end
end

end
