module CGIKit

class Switcher < DynamicElement
  class << self
    def create_api
      api = API.new(:Switcher)
      component = Binding.new(:component)
      component.value_set = Binding::PAGE_NAMES
      component.required = true
      api << component
      api
    end
  end

  def begin_context( context )
    take_value_once(:component)
    context.increment
    unless @switch then
      page = context.session.restore_page(context.context_id)
      if page == root then
        @switch = application.page(@values[:component], context)
        @switch.parent = root
      else
        @switch = page
      end
      @switch.node = @node
      @switch.declaration_name = @name
      @switch.awake_from_restroration(context)
    end
    @switch.begin_context(context)
  end

  def end_context( context )
    @switch.end_context(context)
  end

  def take_values_from_request( request, context )
    @switch.take_values_from_request(request, context)
  end

  def invoke_action( request, context )
    @switch.invoke_action(request, context)
  end

  def append_to_response( response, context )
    @switch.append_to_response(response, context)
  end
end

end
