module CGIKit

  class ResourceURL < DynamicElement
    include ResourceLoadable

    class << self
      def create_api
        api = API.new(:Image)
        data = Binding.new(:data)
        file = Binding.new(:file)
        file.value_set = Binding::RESOURCES
        mime = Binding.new(:mime)
        mime.value_set = Binding::MIME_TYPES
        key = Binding.new(:key)
        api << data
        api << file
        api << package_binding()
        api << mime
        api << key
        api << required_validation([:file, :data])
        api
      end
    end

    def append_to_response( response, context )
      take_value(:file)
      take_value(:package)
      take_value(:data)
      take_value(:key)
      take_value(:mime)
      url = caching_url(@values[:file], @values[:package],
                        @values[:data], @values[:key],
                        @values[:mime], context.request)
      response.content << url
    end
  end

end
