module CGIKit

  class RadioGroup < DynamicElement

    class << self

      def create_api
        api = API.new(:RadioGroup)
        index = Binding.new(:index)
        prefix = Binding.new(:prefix)
        suffix = Binding.new(:suffix)
        api << index
        api << prefix
        api << suffix
        api << list_binding()
        api << item_binding()
        api << selection_binding(true)
        api << name_binding()
        api << value_binding(false, false)
        api << display_binding()
        api << escape_binding()
        api << enabled_binding()
        api
      end

    end

    def begin_context( context )
      context.increment
      context.append_zero
    end

    def end_context( context )
      context.delete
    end

    def take_values_from_request( request, context )
      if value = value_from_request(request, context) then
        take_value(:list)
        set_value(:selection, @values[:list][value.to_i])
      end
    end

    def append_to_response( response, context )
      take_value(:list)
      take_value(:index, false)
      take_value(:name)
      take_value(:selection)
      take_bool(:escape)
      @values[:name] ||= name_value(context)

      @values[:list].each_with_index do |item, index|
        set_value(:item, item)
        set_value(:index, index) if @values[:index]
        take_value(:value)
        take_value(:display)
        take_value(:prefix)
        take_value(:suffix)
        take_bool(:enabled)
        attrs = { :name => @values[:name],
          :disabled => !@values[:enabled],
          :value => (@values[:value] || index.to_s),
          :checked => (@values[:selection] == item) }
        attrs.update(optional_attributes())

        tag = HTMLTag.radio(attrs, other_attribute())
        display = @values[:display] || item.to_s
        display = escaped_string(display) if @values[:escape]
        response.content << \
          "#{@values[:prefix]}#{tag.empty_tag} #{display}#{@values[:suffix]}\n"
        context.increment
      end
    end
  end

end

