module CGIKit

  class Delegate

    module LinkDelegate

      def link_should_invoke_action; end
      def link_generate_url( url ); end
      def link_will_generate_tag( tag ); end

    end

  end


  class Link < DynamicElement

    module Utilities

      def action_url( context )
        take_value(:frag)
        take_value(:page)
        take_value(:action, false)
        take_bool(:secure)
        take_value_query(:query)
        take_value(:session_id)
        take_value(:direct_action, false)
        take_value(:action_class)

        if @values[:page] or @values[:action] then
          # create session if it doesn't have session
          context.session
          url = context.component_action_url(@values[:query], @values[:secure])
        elsif direct_action? then
          url = context.direct_action_url(@values[:action_class],
                                          @values[:direct_action],
                                          @values[:query],
                                          @values[:session_id])
        end
        append_frag(url, @values[:frag]) if @values[:frag]
        url
      end

      def append_frag( url, frag )
        frag = "##{frag}"
        unless url.sub!(/\?/, "#{frag}?") then
          url << frag
        end
        url
      end

      def set_href( tag, context )
        take_value(:href)
        tag[:href] = @values[:href] || action_url(context)
        ask(:link_generate_url) do |d|
          tag[:href] = d.link_generate_url(tag[:href])
        end
        ask(:link_will_generate_tag) do |d|
          tag = d.link_will_generate_tag(tag) || tag
        end
        tag
      end

      module_function :append_frag

    end

    include Utilities

    class << self
      def create_api
        api = API.new(:Link)
        string = Binding.new(:string)

        api << string
        api << action_binding()
        api << enabled_binding()
        api << href_binding()
        api << escape_binding()
        api << page_binding()
        api << secure_binding()
        api << query_binding()
        api << frag_binding()
        api << session_id_binding()
        set_direct_action(api)
        api << required_validation([:action, :href, :page], [], \
                                   [:direct_action, :action_class])
        api
      end
    end

    def begin_context( context )
      context.increment
      context.append_zero
    end

    def end_context( context )
      context.delete
    end

    def invoke_action( request, context )
      ask(:link_should_invoke_action) do |d|
        return unless d.link_should_invoke_action
      end

      take_value(:page)
      take_value(:action, false)
      result = nil
      if context.action?(request) then
        if @values[:page] then
          result = @application.page(@values[:page], context)
        else
          result = @root[@values[:action]]
        end
      end
      result
    end

    def append_to_response( response, context )
      take_value(:name)
      take_bool(:enabled)
      take_bool(:escape)
      take_value(:string)

      if @values[:string] then
        @values[:string] = escaped_string(@values[:string], @values[:escape])
      end

      unless @values[:enabled] then
        if @values[:string] then
          response.content << @values[:string]
        elsif empty? == false then
          @node.append_to_response(response, context)
        end
        return
      end

      attrs = {}
      attrs.update(optional_attributes())
      tag = HTMLTag.a(attrs, other_attribute())
      set_href(tag, context)
      response.content << tag.open_tag
      if empty? == false then
        @node.append_to_response(response, context)
      elsif @values[:string] then
        response.content << @values[:string]
      end
      response.content << tag.close_tag
    end

  end

end
