module CGIKit

  class ImageSubmit < Submit

    module Utilities

      def x_y_values_from_request( request, context )
        xnames = ["#{context.context_id}.x"]
        ynames = ["#{context.context_id}.y"]
        if @values[:name] then
          xnames << "#{@values[:name].to_s}.x"
          ynames << "#{@values[:name].to_s}.y"
        end
        x = y = nil
        xnames.each do |name|
          if x = request.form_values[name] then
            x = x[0].to_i
            break
          end
        end
        ynames.each do |name|
          if y = request.form_values[name] then
            y = y[0].to_i
            break
          end
        end
        [x, y]
      end

    end

    include ResourceLoadable
    include ImageSubmit::Utilities

    DELETE_KEYS = [:type]

    class << self

      def create_api
        api = API.new(:Sumbit)
        action = Binding.new(:action)
        value = Binding.new(:value)
        value.default = 'Submit'
        data = Binding.new(:data)
        key = Binding.new(:key)
        api << data
        api << key
        api << action
        api << value
        api << enabled_binding()
        api << name_binding()
        api << file_binding()
        api << package_binding()
        api << mime_binding()
        api << src_binding()
        api << x_binding()
        api << y_binding()
        set_direct_action(api)
        api << any_validation([:action], [], [:direct_action, :action_class])
        api
      end

      def keys_to_delete_from_associations
        DELETE_KEYS
      end

    end

    def take_values_from_request( request, context )
      x, y = x_y_values_from_request(request, context)
      if x and y then
        set_value(:x, x)
        set_value(:y, y)
      end
    end

    def append_to_response( response, context )
      take_value(:file)
      take_value(:package)
      take_value(:data)
      take_value(:key)
      take_value(:mime)
      take_value(:value)
      take_value(:src)
      take_bool(:enabled)
      attrs = { :type => 'image', :name => name_value(context),
        :value => @values[:value], :disabled => !@values[:enabled],
        :src => @values[:src] }
      attrs.update(optional_attributes())
      unless attrs[:src] then
        attrs[:src] = caching_url(@values[:file], @values[:package],
                                  @values[:data], @values[:key],
                                  @values[:mime], context.request)
      end
      ask(:image_generate_url) do |d|
        attrs[:src] = d.image_generate_url(attrs[:src])
      end
      attrs[:value] = escaped_string(attrs[:value]) if attrs[:value]
      tag = HTMLTag.input(attrs, other_attribute())
      ask(:submit_will_generate_tag) do |d|
        tag = d.submit_will_generate_tag(tag) || tag
      end
      response.content << tag.empty_tag
    end

  end

end
