module CGIKit

  class Delegate

    module ImageDelegate

      def image_generate_url( url ); end
      def image_will_generate_tag( tag ); end

    end

  end


  class Image < DynamicElement
    include ResourceLoadable

    class << self
      def create_api
        api = API.new(:Image)
        data = Binding.new(:data)
        file = Binding.new(:file)
        file.value_set = Binding::RESOURCES
        mime = Binding.new(:mime)
        mime.value_set = Binding::MIME_TYPES
        key = Binding.new(:key)
        api << data
        api << file
        api << mime
        api << key
        api << src_binding()
        api << package_binding()
        api << required_validation([:file, :src, :data])
        api
      end
    end

    def append_to_response( response, context )
      take_value(:file)
      take_value(:package)
      take_value(:data)
      take_value(:key)
      take_value(:mime)
      take_value(:src)

      unless @values[:src] then
        @values[:src] = caching_url(@values[:file], @values[:package],
                                    @values[:data], @values[:key],
                                    @values[:mime], context.request)
      end
      ask(:image_generate_url) do |d|
        @values[:src] = d.image_generate_url(@values[:src])
      end

      attrs = { :src => @values[:src] }
      attrs.update(optional_attributes())
      tag = HTMLTag.img(attrs, other_attribute())
      ask(:image_will_generate_tag) do |d|
        tag = d.image_will_generate_tag(tag) || tag
      end
      response.content << tag.empty_tag
    end
  end

end
