module CGIKit

class GenericElement < DynamicElement

  NO_CLOSE_TAGS = [ 'area', 'base', 'basefont', 'br', 'col', 'frame', 'hr',
                    'img', 'input', 'link', 'map', 'meta', 'param' ]
  NAME_TAGS = ['frame', 'form', 'input', 'select', 'textarea', 'button',
               'a', 'img', 'map', 'applet', 'iframe', 'meta', 'object', 'param']
  VALUE_TAGS = ['param', 'li', 'input', 'option', 'button']
  HREF_TAGS = ['a', 'area']

  class << self
    def create_api
      api = API.new(:GenericElement)
      tag = Binding.new(:tag)
      tag.required = true
      displayed = Binding.new(:displayed)
      displayed.value_set = Binding::BOOLEAN
      displayed.default = true
      form_value = Binding.new(:form_value)
      form_values = Binding.new(:form_values)
      invoke_action = Binding.new(:invoke_action)
      api << tag
      api << displayed
      api << form_value
      api << form_values
      api << invoke_action
      api << name_binding()
      api
    end
  end


  #
  # testing
  #

  def form?
    @values[:tag].downcase == 'form'
  end

  def link?
    @values[:tag].downcase == 'a'
  end

  def no_close_tag?( tag )
    NO_CLOSE_TAGS.include?(tag)
  end

  def has_name?( tag )
    NAME_TAGS.include?(tag)
  end

  def has_value?( tag )
    VALUE_TAGS.include?(tag)
  end

  def has_href?( tag )
    HREF_TAGS.include?(tag)
  end


  #
  # request-response loop
  #

  def begin_context( context )
    take_value(:name)
    take_value(:tag)
    context.increment(@values[:name])
    if form? then
      context.append_zero
      context.in_form = true
    elsif link? then
      context.append_zero
    end
  end

  def end_context( context )
    if form? then
      context.delete
      context.in_form = false
    elsif link? then
      context.delete
    end
  end

  def take_values_from_request( request, context )
    if form_values = values_from_request(request, context) then
      if declared?(:form_value) then
         set_value(:form_value, form_values[0])
      elsif declared?(:form_values) then
         set_value(:form_values, form_values)
      end
    end
    @node.take_values_from_request(request, context)
  end

  def invoke_action( request, context )
    take_value(:invoke_action, false)
    result = nil
    if declared?(:invoke_action) then
      if (link? and context.action?(request)) or \
        value_from_request(request, context) then
        result = @root[@values[:invoke_action]]
      end
    else
      result = @node.invoke_action(request, context)
    end
    result
  end

  def append_to_response( response, context )
    take_bool(:displayed)
    take_value(:form_value)
    take_value(:form_values)
    unless @values[:displayed] then return end

    if @values[:form_value] then
      value = @values[:form_value]
    elsif @values[:form_values] then
      value = @values[:form_values]
    end

    html =  "<#{@values[:tag]}"
    if has_name?(@values[:tag]) then
      html << " name=\"#{name_value(context)}\""
    end
    if has_value?(@values[:tag]) and \
      (declared?(:form_value) or declared?(:form_values)) then
      html << " value=\"#{value}\""
    end
    if has_href?(@values[:tag]) and declared?(:invoke_action) then
      url = context.url(context.request.request_handler_key)
      html << " href=\"#{url}\""
    end
    html << other()
    if no_close_tag?(@values[:tag]) then
      html << ' />'
    else
      html << '>'
    end
    response.content << html
    unless empty? then
      @node.append_to_response(response, context)
    end

    unless no_close_tag?(@values[:tag]) then
      response.content << "</#{@values[:tag]}>"
    end
  end

end

end
