module CGIKit

  class CheckboxGroup < DynamicElement

    class << self

      def create_api
        api = API.new(:CheckboxGroup)
        index = Binding.new(:index)
        prefix = Binding.new(:prefix)
        suffix = Binding.new(:suffix)
        api << index
        api << prefix
        api << suffix
        api << list_binding()
        api << item_binding()
        api << selections_binding(true)
        api << name_binding()
        api << display_binding()
        api << escape_binding()
        api << enabled_binding()
        api
      end

    end

    DEFAULT_VALUE = '1'

    def begin_context( context )
      context.increment
      context.append_zero
    end

    def end_context( context )
      context.delete
    end

    def take_values_from_request( request, context )
      take_value(:list)
      take_value(:selections)
      unless @values[:selections] then
        @values[:selections] = []
        set_value(:selections, @values[:selections])
      end
      @values[:selections].clear
      @values[:list].each_with_index do |item, index|
        if value_from_request(request, context) then
          @values[:selections] << item
        end
        context.increment
      end
    end

    def append_to_response( response, context )
      take_value(:list)
      take_value(:index, false)
      take_value(:selections)
      take_bool(:escape)

      @values[:list].each_with_index do |item, index|
        set_value(:item, item)
        set_value(:index, index) if @values[:index]
        take_value(:name)
        take_value(:display)
        take_value(:prefix)
        take_value(:suffix)
        take_bool(:enabled)
        attrs = { :name => name_value(context),
          :disabled => !@values[:enabled],
          :value => DEFAULT_VALUE,
          :checked => @values[:selections].include?(item) }
        attrs.update(optional_attributes())

        tag = HTMLTag.checkbox(attrs, other_attribute())
        display = @values[:display] || item.to_s
        display = escaped_string(display) if @values[:escape]
        response.content << \
          "#{@values[:prefix]}#{tag.empty_tag} #{display}#{@values[:suffix]}\n"
        context.increment
      end
    end
  end

end

