module CGIKit

  class ActionURL < Link
    include Link::Utilities

    class << self
      def create_api
        api = API.new(:ActionURL)
        api << action_binding()
        api << page_binding()
        api << secure_binding()
        api << query_binding()
        api << frag_binding()
        api << session_id_binding()
        set_direct_action(api)
        api << required_validation([:action, :page], [], \
                                   [:direct_action, :action_class])
        api
      end
    end

    def begin_context( context )
      context.increment
    end

    def end_context( context ); end

    def append_to_response( response, context )
      response.content << action_url(context)
    end

  end

end
