module CGIKit::Ajax

  module XMLSerializer

    def serialize( object )
      data = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n"
      data << "<param method=\"POST\">\n"
      unless object.nil? then
        if Array === object then
          data << serialize_array(object)
        elsif Hash === object then
          data << serialize_hash(object)
        else
          raise "an object is not array or hash."
        end
      end
      data << "</param>\n"
      data
    end

    def serialize_array( array )
      data = ''
      hash.each do |key, value|
        data << "<#{key.to_s}>#{value.to_s}</#{key.to_s}>\n"
      end
      data
    end

    def serialize_hash( hash )
      data = ''
      hash.each do |key, value|
        data << "<name>#{key.to_s}</name>\n"
        data << "<value>#{value.to_s}</#{key.to_s}>\n"
      end
      data
    end

    module_function :serialize
    module_function :serialize_array
    module_function :serialize_hash
  end

end

