module CGIKit

  class Aspect
    
    class AspectError < StandardError; end
    
    attr_accessor :target
    
    class << self
      
      attr_accessor :never_wrap
      
      def advice_methods
        @advice_methods.clone
      end
      
      def init_aspect
        @advice_methods = []   
      end
      
      private :init_aspect
    
      def alias_method_name(method_name, as = '')
        '__aop' + self.object_id.to_s + '__' + method_name.gsub(/\W/){|i| i[0].to_s } + '__' + as.to_s.gsub(/\W/){|i| i[0].to_s }
      end
      
      def inst_varname
        '@__aop' + self.object_id.to_s
      end
      
      def advice(*args)
        @advice_methods.concat( args.collect{|i| i.to_s} )
      end
    
      # don't use Class#public_instance_methods(false)
      def inherited(klass)
        parent = klass.superclass
        args = parent.advice_methods #& (parent.public_instance_methods - Aspect.public_instance_methods)
        
        klass.__send__(:init_aspect)
        klass.advice(*args)
      end
      
    end
    
    Aspect.__send__(:init_aspect)
    
  end
  
end



class Object
  
  def extend_aspect(as, pointcut)
    aop_check_aspect(as)
    
    if self.instance_variable_get(as.inst_varname)
      return nil
      #raise CGIKit::Aspect::AspectError, "Can't apply aspect twice: " + as.name
    end
    
    obj = as.new
    obj.target = self
    self.instance_variable_set(as.inst_varname, obj)
    
    aop_apply_aspect(as, pointcut)
  end
  
  protected
  def aop_check_aspect(as)
    unless CGIKit::Aspect >= as
      raise CGIKit::Aspect::AspectError, "argument is not CGIKit::Aspect : " + as.name
    end
    
    diff = as.advice_methods - as.public_instance_methods
    if diff.size > 0
      raise CGIKit::Aspect::AspectError, "advice(method) is not defined: " + as.name + ' ' + diff.collect{|i| '#' + i.to_s }.join(', ')
    end
  end
  
  def aop_apply_aspect(as, pointcut)
    as.advice_methods.each do |advice|
      if Hash === pointcut
        judge = pointcut[advice] || pointcut[advice.to_sym]
      else
        judge = pointcut
      end
      
      if Class === self
        arr = self.public_instance_methods
      else
        arr = self.methods
      end

      case judge          
      when Regexp
        arr = arr.select{|name| judge =~ name}
      when Array
        arr = arr & judge.collect{|i| i.to_s }
      when Method, Proc
        arr = arr.select{|name| judge.call(name) }
      else
        return 
      end
                
      if as.never_wrap
        re = /^aop_|^__send__$|^object_id$|^__id__$|^class$|#{as.never_wrap}/
      else
        re = /^aop_|^__send__$|^object_id$|^__id__$|^class$/
      end
      arr = arr.delete_if{|met| re =~ met }
      arr.each do |weaved|
        aop_apply_advice_to_method(as, advice, weaved)
      end
    end
  end
  
  def aop_apply_advice_to_method(as, advice, weaved_method)
    aliased = as.alias_method_name(weaved_method, advice)
    
    if Class === self
      return if self.method_defined?(aliased)
      alias_method(aliased, weaved_method)
    else
      return if self.respond_to?(aliased)
      
      Thread.current[:aliased] = aliased
      Thread.current[:weaved_method] = weaved_method
      class << self
        self.__send__( :alias_method, Thread.current[:aliased], Thread.current[:weaved_method] )
      end
    end
    
    if Class === self
      arity = self.instance_method(weaved_method).arity      
    else
      arity = self.method(weaved_method).arity
    end
    if arity < 0
      args = (0...(-1-arity)).to_a.collect{|i| "arg#{i}"}.join(",")
      args << "," if arity < -1
      args << "*args, &block"
    elsif arity > 0
      args = ''
      (0..(arity-1)).each{|i| args << "arg#{i}, " }
      args << "&block"
    else
      args = "&block"
    end
    args_without_block = args.sub(/,?\s*\&block$/, '').strip
    advice_args = (args_without_block == '') ? "'#{weaved_method}'" : ("'#{weaved_method}', " + args_without_block)
    call_orig_with_block = "#{aliased}(#{args_without_block}){|*i| block.call(*i) }"
    call_orig            = "#{aliased}(#{args_without_block})"
    
    if as.instance_method(advice).arity == 0
      s = <<-EOF
      def #{weaved_method}(#{args})
        as_obj = #{as.inst_varname}
        if block 
          as_obj.#{advice}{     #{call_orig_with_block}     }
        else
          as_obj.#{advice}{     #{call_orig}    }
        end
      end
      EOF
    else
      s = <<-EOF
      def #{weaved_method}(#{args})
        as_obj = #{as.inst_varname}
        if block 
          as_obj.#{advice}(#{advice_args}){     #{call_orig_with_block}     }
        else 
          as_obj.#{advice}(#{advice_args}){     #{call_orig}    }    
        end
      end
      EOF
    end
       
    aop_define_method_by_string(s, __FILE__, 160)
  end
  
  def aop_define_method_by_string(s, name, lineno)
    self.instance_eval(s, name, lineno)
  end
  
end

class Class
    
  def include_aspect(as, pointcut)
    aop_check_aspect(as)
    
    unless self.respond_to?(:aop_orig_new)
      class << self
        alias_method(:aop_orig_new, :new)
      end
      
      def self.set_aspects(obj, arr)
        arr.each do |as|
          i = as.new
          i.target = obj
          obj.instance_variable_set(as.inst_varname, i)
        end
      end
      
      body = <<-EOF
      def new(*args, &block)
        obj = self.aop_orig_new(*args){|*is|block.call(*is)}
        self.set_aspects(obj, self.instance_variable_get("@aspects"))
        obj
      end
      EOF
      
      self.instance_eval(body)
    end
    
    
    self.aop_add_aspect(as)
    aop_apply_aspect(as, pointcut)
  end
  
  protected
  
  def aop_add_aspect(aspect)
    @aspects = @aspects || []
    @aspects << aspect
  end
  
  # can't use define_method because of block parameter
  def aop_define_method_by_string(s, name, lineno)
    self.class_eval(s, name, lineno)
  end
  
end

module CGIKit
  
  class Aspect
  
    module Context
      
      def current_context(method_name)
        s = "<Thread:#{Thread.current.object_id}> "
        s << self.target.class.name
        if Module === self.target
          s << '.'
        else      
          s << '#'
        end
        
        s << method_name
        s << ': '
        s
      end
      
    end
    
  end
  
end

=begin
module CGIKit
  
  module Filter
    
    class Filter
      attr_accessor :option, :block, :method_name
    end
    
    @mod2filters = {}
    
    def self.module2filters(mod)
      @mod2filters[mod]
    end
    
    def self.set_filters(mod, filters)
      @mod2filters[mod] = filters
    end
    
    
    
    def init_filter
      self.class.public_instance_methods(false)
    end
    
    
    def append_feature(klass)
      a = []
      b = []
            
      
      klass.instance_variable_set('@af', a)
      klass.instance_variable_set('@bf', b)
      
      klass.__send__(:define_method, :bf){|args|
        if args.include(:only)
          
        end
        if args.include(:except)
          
        end
        (args - [:only, :except]).each do |i|
          @bf << Filter.new(option)
        end        
      }
      
      klass.__send__(:define_method, :af){|args|
        @as = @as || []
        
        
      }      
    end
    
  end
  
end

=end

