#!/usr/bin/ruby

$LOAD_PATH.unshift('../')

require 'cgikit'
require 'pstore'

class BBSPage < CGIKit::Component
	
	attr_accessor :i
	
	def get_list
		if @list.nil?
			db = PStore.new('bbs_data.dat')
			db.transaction do |data|
				if data.root?('data') 
					@list = data['data']
				else
					@list = []
				end
			end
		end
		
		@list
	end
	
	def get_cur_name
		@i['name']
	end
	
	def get_cur_content
		@i['content']
	end
	
end


if $0 == __FILE__
	app = CGIKit::Application.new  
	app.main = 'BBSPage'
	app.cache_template = false
	
	app.run
end
