if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'cgikit/command'
	require 'TestApp/app'
	require 'TestApp/UploadPage/UploadPage'
	require 'test_common'
end


class TestElementUpload < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@app.main = UploadPage
		@does_test_other = true
	end

	def test_api_correct
		dec = {:TestAPI => {:element => Upload, :value => :test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_api_nothing_bound
		dec = {:TestAPI => {:element => Upload}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_value
		response = @app.run
		command = Command.new(response)
		command.control(UploadPage::TEST_VALUE_NAME)[:value] = @app.sample_image_data
		command.submit_at(0).submit
		response = @app.run(command)
		value = response.component.value_for_key(UploadPage::TEST_VALUE)
		assert_kind_of(ByteData, value)
		assert_not_nil(value.path)
		assert_not_nil(value.content_type)
	end

	def test_enabled
		response = @app.run()
		command = Command.new(response)
		assert_equal(false, command.control(UploadPage::TEST_ENABLED_NAME).enabled?)
	end

end


if __FILE__ == $0 then
	suite = TestElementUpload.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
