if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'cgikit/command'
	require 'TestApp/app'
	require 'TestApp/TextFieldPage/TextFieldPage'
	require 'TestApp/FramePage/FramePage'
	require 'test_common'
end


class TestElementFrame < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@app.main = FramePage
		@does_test_other = true
	end

	def test_api_nothing_bound
		dec = {:TestAPI => {:element=>Frame}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_api_page_src_value_bound
		dec = {:TestAPI => {:element=>Frame, :page=>:test, :value=>:test, :src=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_api_page_bound
		dec = {:TestAPI => {:element=>Frame, :page=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_api_src_bound
		dec = {:TestAPI => {:element=>Frame, :src=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_api_value_bound
		dec = {:TestAPI => {:element=>Frame, :value=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_src
		response = @app.run
		command = Command.new(response)
		frame = command.element(FramePage::TEST_SRC_NAME)
		assert_equal(FramePage::TEST_SRC, frame[:src])
	end

	def test_page
		response = @app.run
		command = Command.new(response)
		frame = command.element(FramePage::TEST_PAGE_NAME)
		command = frame.command_from_src
		response = @app.run(command)
		assert_kind_of(FramePage::TEST_PAGE, response.component)

		expected = 'test_value'
		command = Command.new(response)
		command.control(TextFieldPage::TEST_VALUE_NAME)[:value] = expected
		command.submit_at(0).submit
		response = @app.run(command)
		assert_equal(expected, response.component.value_string)
	end

	def test_value
		response = @app.run
		command = Command.new(response)
		frame = command.element(FramePage::TEST_VALUE_NAME)
		command = frame.command_from_src
		response = @app.run(command)
		assert_kind_of(FramePage::TEST_VALUE_CLASS, response.component)

		expected = 'test_value'
		command = Command.new(response)
		command.control(TextFieldPage::TEST_VALUE_NAME)[:value] = expected
		command.submit_at(0).submit
		response = @app.run(command)
		assert_equal(expected, response.component.value_string)
	end

end


if __FILE__ == $0 then
	suite = TestElementFrame.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
