if __FILE__ == $0
  $LOAD_PATH.unshift '../lib' 
  require 'test/unit'
  require 'test/unit/ui/console/testrunner'
  require 'cgikit'
  require 'cgikit/command'
  require 'TestApp/app'
  require 'TestApp/FormPage/FormPage'
  require 'test_common'
end


class TestElementForm < Test::Unit::TestCase
  include CGIKit, TestCommon, DirectActionAPITesting

  def setup
    @app = testapp()
    @app.main = FormPage
     @direct_action_element = Form
  end

  def test_api_nothing_bound
    dec = {:TestAPI => {:element=>Form}}
    store = DeclarationStore.new_from_hash(dec)
    assert_nothing_raised{ store.validate_api }
  end

  def test_api_either_enctype_or_upload_bound
    dec = {:TestAPI => {:element=>Form, :enctype=>:enctype, :upload=>true}}
    store = DeclarationStore.new_from_hash(dec)
    assert_raises(ValidationError) { store.validate_api }
  end

  def test_api_either_href_or_action_bound
    dec = {:TestAPI => {:element=>Form, :href=>:href, :action=>:action}}
    store = DeclarationStore.new_from_hash(dec)
    assert_raises(ValidationError) { store.validate_api }
  end

  def test_api_all_bound
    dec = {:TestAPI => {:element=>Form, :enctype=>:enctype, :method=>:method, \
      :query=>{}}}
    store = DeclarationStore.new_from_hash(dec)
    assert_nothing_raised { store.validate_api }
  end

  def test_enctype_method_query
    response = @app.run
    command = Command.new(response)
    assert(FormPage.test_enctype(command))
    assert(FormPage.test_method(command))
    assert(FormPage.test_query(command))
  end

  def test_href
    response = @app.run
    command = Command.new(response)
    assert(FormPage.test_href(command))
  end

  def test_upload
    response = @app.run
    command = Command.new(response)
    assert(FormPage.test_upload(command))
  end

  def test_submit_action
    response = @app.run
    command = Command.new(response)
    command.submit(FormPage::TEST_SUBMIT_WITH_ACTION_NAME).submit
    response = @app.run(command)
    assert(FormPage.test_submit_action(response.content))
  end

  def test_form_action
    response = @app.run
    command = Command.new(response)
    command.submit(FormPage::TEST_SUBMIT_WITHOUT_ACTION_NAME).submit
    response = @app.run(command)
    assert(FormPage.test_form_action(response.content))
  end

  def test_direct_action
    response = @app.run
    command = Command.new(response)
    command.submit(FormPage::TEST_SUBMIT_DIRECT_ACTION_NAME).submit
    response = @app.run(command)
    assert(FormPageDirectAction.test_direct_action(response.content))
  end

end


if __FILE__ == $0 then
  suite = TestElementForm.suite
  runner = Test::Unit::UI::Console::TestRunner.new suite
  runner.start
end
