if __FILE__ == $0
  $LOAD_PATH.unshift '../lib' 
  require 'test/unit'
  require 'test/unit/ui/console/testrunner'
  require 'cgikit'
  require 'cgikit/command'
  require 'cgikit/displaygroup'
end


class TestDisplayGroup < Test::Unit::TestCase
  include CGIKit

  def setup
    @data = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
    @group = DisplayGroup.new
    @group.objects = @data
  end

  def test_insert_and_delete_at
    obj = 'test'
    i = 0
    @group.insert(i, obj)
    assert(@group.objects.include?(obj))
    @group.delete_at(i)
    assert(!@group.objects.include?(obj))
  end

  def test_insert_new_object
    default = {'key'=>'value'}
    @group.default_values = default
    @group.insert
  end

  def test_insert_without_selection
    @group.insert
    assert(!@group.objects[0].nil?)
  end

  def test_insert_with_selection
    @group.selection = @data[0]
    @group.insert
    assert_not_equal(@data[0], @group.objects[1])
  end

  def test_delete_selection
    @group.selection = @data[0]
    obj = @data[0]
    @group.delete
    assert_not_equal(obj, @group.objects[0])
  end

  def test_clear_selection
    @group.clear_selection
    assert(@group.selections.empty?)
    assert(@group.selection_indexes.empty?)
  end

  def test_set_selection
    i = 0
    @group.selection = @data[i]
    assert_equal(@data[i], @group.selection)
    assert(@group.selection_indexes.include?(i))
  end

  def test_set_selections
    i = [0, 1]
    objs = [@data[0], @data[1]]
    @group.selections = objs
    assert_equal(objs, @group.selections)
    assert_equal(i, @group.selection_indexes)
  end

  def test_select_next
    i = 5
    @group.selection = @data[i]
    @group.select_next
    assert_equal(@data[i+1], @group.selection)
  end

  def test_select_pre
    i = 5
    @group.selection = @data[i]
    @group.select_pre
    assert_equal(@data[i-1], @group.selection)
  end

  def test_display_next_and_pre
    @group.per_page = 2
    assert_equal([@data[0], @data[1]], @group.displays)
    @group.display_next
    assert_equal([@data[2], @data[3]], @group.displays)
    assert(@group.selections.empty?)
    @group.display_pre
    assert_equal([@data[0], @data[1]], @group.displays)
  end

  def test_set_page_index
    @group.per_page = 3
    @group.page_index = 1
    assert_equal([@data[0], @data[1], @data[2]], @group.displays)
    @group.page_index = 2
    assert_equal([@data[3], @data[4], @data[5]], @group.displays)
  end

  def test_page_count
    @group.per_page = 2
    assert_equal(5, @group.page_count)
  end

  def test_has_multiple_pages
    @group.per_page = 2
    assert(@group.multiple_pages?)
    @group.per_page = 10
    assert(!@group.multiple_pages?)
  end

  def test_add_and_remove_sort_key
    key = 'key'
    method = :method
    @group.add_sort_key(key, method)
    sort = @group.sort_keys[0]
    assert_equal(key, sort.key)
    assert_equal(method, sort.method)
    @group.remove_sort_key(key)
    assert_nil(@group.sort_keys[0])
  end

  def test_sorter_from_sort_keys
    a = 'abc'
    b = 'ab'
    @group.add_sort_key(:size, :>)
    sorter = @group.sorter_from_sort_keys
    assert_equal(1, sorter.call(a, b))
  end

  def test_sort
    @group.per_page = @group.objects.size
    @group.add_sort_key(:to_i, :<)
    @group.update
    assert(@group.displays.first > @group.displays.last)
  end

  def test_qualifier_from_query_values
    @group.query_min[:to_i] = 3
    @group.query_max[:to_i] = 6
    @group.query_match[:to_s] = /[1-9]/
    @group.query_operator[:to_s] = :=~
    @group.query_mode = true
    @group.per_page = @group.objects.size
    qual = @group.qualifier_from_query_values
    assert(qual.call(3))
    assert(qual.call(6))
    assert(!qual.call(2))
    assert(!qual.call(7))
  end

  def test_qualify
    @group.query_min[:to_i] = 3
    @group.query_max[:to_i] = 6
    @group.query_mode = true
    @group.per_page = @group.objects.size
    @group.qualify
    assert_equal([3, 4, 5, 6], @group.displays)
  end

end


if __FILE__ == $0 then
  suite = TestDisplayGroup.suite
  runner = Test::Unit::UI::Console::TestRunner.new suite
  runner.start
end
