if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'cgikit/command'
	require 'TestApp/app'
	require 'TestApp/ComponentPage/ComponentPage'
	require 'TestApp/SubcomponentPage/SubcomponentPage'
	require 'test_common'
end


class TestComponent < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@app.main = ComponentPage
		@request = Request.new
	end


	#
	# nesting
	#

	def test_nest_display
		response = @app.run
		pattern = /#{SubcomponentPage::TEST_DISPLAY}/
		assert_match(pattern, response.content)
	end

	def test_nest_set_values
		expected = 'test nest set values'
		response = @app.run
		command = Command.new(response)
		field = command.element(SubcomponentPage::TEST_SET_VALUE_NAME)
		field[:value] = expected
		field.form.submit_form

		response = @app.run(command)
		command = Command.new(response)
		field = command.element(SubcomponentPage::TEST_SET_VALUE_NAME)
		assert_equal(expected, field[:value])

		sub = response.component.subcomponents[0]
		assert_equal(expected, sub[SubcomponentPage::TEST_SET_VALUE_KEY])
	end

	def test_nest_perform_parent_action
		response = @app.run
		command = Command.new(response)
		link = command.element(SubcomponentPage::TEST_PERFORM_PARENT_ACTION_NAME)
		link.submit
		response = @app.run(command)
		command = Command.new(response)
		assert_equal(SubcomponentPage::TEST_ACTION_OK, response.component[ComponentPage::FLAG])
	end


	#
	# managing session
	#

	def test_terminate_session
		response = @app.run
		command = Command.new(response)
		sid = response.component.session.session_id
		command.link(ComponentPage::TEST_TERMINATE_SESSION_NAME).submit

		response = @app.run(command)
		assert(response.component.session.terminate?)
		assert(!@app.session_store.exist?(sid))
	end


	#
	# caching
	#

	def test_generate_cache
		@app.cache_template = true
		response = @app.run
		assert(@app.template_store.exist?(response.component))
	end

	def test_terminate_template_cache
		@app.cache_template = true
		response = @app.run
		component = response.component
		def component.will_parse_template; ''; end
		assert(@app.template_store.terminate_template?(Template.new, component))
	end

	def test_terminate_declaration_cache
		@app.cache_template = true
		response = @app.run
		component = response.component
		def component.will_parse_declaration; {}; end
		assert(@app.template_store.terminate_declaration?(Template.new, component))
	end

end


if __FILE__ == $0 then
	suite = TestComponent.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
