#!/usr/local/bin/ruby

$LOAD_PATH.unshift '../lib'
$LOAD_PATH.unshift 'TestApp'

require 'rexml/document'
require 'cgikit'
require 'cgikit/command'
require 'TestApp/app'
require 'TestApp/ApplicationPage/ApplicationPage'
require 'TestApp/ComponentPage/ComponentPage'
require 'TestApp/SubcomponentPage/SubcomponentPage'
require 'TestApp/BrowserPage/BrowserPage'
require 'TestApp/EmptyPage/EmptyPage'
require 'TestApp/StringPage/StringPage'
require 'TestApp/CheckboxPage/CheckboxPage'
require 'TestApp/ConditionalPage/ConditionalPage'
require 'TestApp/ContentPage/ContentPage'
require 'TestApp/FormPage/FormPage'
require 'TestApp/GenericElementPage/GenericElementPage'
require 'TestApp/ImagePage/ImagePage'
require 'TestApp/LinkPage/LinkPage'
require 'TestApp/PopupPage/PopupPage'
require 'TestApp/RadioPage/RadioPage'
require 'TestApp/RepetitionPage/RepetitionPage'
require 'TestApp/ResetPage/ResetPage'
require 'TestApp/SubmitPage/SubmitPage'
require 'TestApp/TextPage/TextPage'
require 'TestApp/TextFieldPage/TextFieldPage'
require 'TestApp/UploadPage/UploadPage'
require 'TestApp/FramePage/FramePage'
require 'TestApp/SessionPage/SessionPage'
require 'TestApp/ComponentRequestHandlerPage/ComponentRequestHandlerPage'
require 'test/unit'
require 'test/unit/ui/console/testrunner'
require 'test_common'
require 'test_api'
require 'test_application'
require 'test_association'
require 'test_key_value_coding'
require 'test_request_handler'
require 'test_component_request_handler'
require 'test_direct_action_request_handler'
require 'test_resource_request_handler'
require 'test_session'
require 'test_session_store'
require 'test_declaration'
require 'test_component'
require 'test_context'
require 'test_element_browser'
require 'test_element_checkbox'
require 'test_element_conditional'
require 'test_element_form'
require 'test_element_frame'
require 'test_element_genericelement'
require 'test_element_image'
require 'test_element_link'
require 'test_element_popup'
require 'test_element_radio'
require 'test_element_repetition'
require 'test_element_reset'
require 'test_element_string'
require 'test_element_text'
require 'test_element_textfield'
require 'test_element_upload'


suite = Test::Unit::TestSuite.new 'CGIKit TestSuite'
level = 2

ObjectSpace.each_object(Class) do |klass|
	if (klass.ancestors.include?(Test::Unit::TestCase)) and \
		(klass != Test::Unit::TestCase) then
		suite << klass.suite
	end
end

Test::Unit::UI::Console::TestRunner.run(suite, level)


def delete_session_files
	path = File.join('tmp', CGIKit::FileSessionStore::TMPDIR)
	Dir.foreach(path) do |file|
		filepath = File.join(path, file)
		if (FileTest.file? filepath) and (file =~ /\A[^\.]/) then
			File.delete filepath
			# puts "delete #{filepath}"
		end
	end
end

delete_session_files

