module CGIKit::Project

  class WEBrickScriptTemplate < ScriptTemplate

    def template_en
      <<EOF
#!#{@project.ruby_path}

# #{@project.name}.rb [port]

$LOAD_PATH.unshift('lib')
require 'webrick'
require 'cgikit'
require 'cgikit/webrick'
require 'application'
require 'session'
require 'directaction'

port = (ARGV.shift || #{ApplicationTemplate::DEFAULT_PORT}).to_i

app = #{@project.application.class_name}.new
app.load_all_components('#{ComponentTemplate::COMPONENT_LIB}')
app.load_configuration('#{ConfigurationTemplate::CONF_FILE}')

server = WEBrick::HTTPServer.new({:Port => port})
server.mount('/', WEBrick::CGIKitServlet::ApplicationHandler, app)

trap("INT"){ server.shutdown }
server.start
EOF
    end

  end

end

