module CGIKit

  class MadeleineDataSource < DataSource

    attr_accessor :madeleine, :getter, :setter, :deleter

    def initialize( madeleine,
                    getter = MadeleineGetter,
                    setter = MadeleineSetter,
                    deleter = MadeleineDeleter )
      @madeleine = madeleine
      @getter = getter
      @setter = setter
      @deleter = deleter
    end

    def fetch
      @madeleine.execute_command(@getter.new)
    end

    def insert( object )
      @madeleine.execute_command(@setter.new(object))
    end

    def delete(object)
      @madeleine.execute_command(@deleter.new(object))
    end

  end


  class MadeleineGetter

    def execute( system )
      system
    end

  end


  class MadeleineSetter

    def initialize( object )
      @object = object
    end

    def execute( system )
      system << @object
    end

  end


  class MadeleineDeleter

    def initialize( object )
      @object = object
    end

    def execute( system )
      system.delete(@object)
    end

  end


end

