module CGIKit

class Upload < DynamicElement

  class << self
    def create_api
      api = API.new(:Upload)
      api << value_binding()
      api << enabled_binding()
      set_validation(api)
      api
    end

    def keys_to_delete_from_associations
      [:type]
    end
  end

  def begin_context( context )
    take_value(:name)
    context.increment(@values[:name])
  end

  def take_values_from_request( request, context )
    if (value = value_from_request(request, context)) and (ByteData === value) then
      set_value(:value, value)
      validate(:value)
    end
  end

  def append_to_response( response, context )
    html  = "<input type=\"file\" name=\"#{name_value(context)}\""
    html << other()
    html << enabled()
    html << "/>"
    response.content << html
  end
end

end
