module CGIKit

class Reset < DynamicElement

  class << self
    def create_api
      api = API.new(:Reset)
      value = Binding.new(:value)
      value.default = 'Reset'
      api << value
      api << enabled_binding()
      api
    end

    def keys_to_delete_from_associations
      [:type]
    end
  end

  def begin_context( context )
    take_value(:name)
    context.increment(@values[:name])
  end

  def append_to_response( response, context )
    take_value(:value)
    html  = "<input type=\"reset\" name=\"#{name_value(context)}\" value=\"#{escaped_string(@values[:value])}\""
    html << other()
    html << enabled()
    html << "/>"
    response.content << html
  end

end

end
