module CGIKit

class Repetition < DynamicElement

  class << self
    def create_api
      api = API.new(:Repetition)
      index = Binding.new(:index)
      count = Binding.new(:count)
      key = Binding.new(:key)
      key.settable = true
      api << list_binding(false)
      api << item_binding()
      api << index
      api << count
      api << key
      api << required_validation([:count, :list])
      api
    end
  end

  def begin_context( context )
    context.increment
    context.append_zero
  end

  def end_context( context )
    context.delete
  end

  def take_values_from_request( request, context )
    take_value(:index, false)
    take_value(:count)
    take_value(:list)

    each do |node|
      node.take_values_from_request(request, context)
      increment_context_for_next_loop(context)
    end
  end

  def increment_context_for_next_loop( context )
    context.delete
    context.increment
    context.append_zero
  end

  def invoke_action( request, context )
    result = nil
    each do |node|
      if node_result = node.invoke_action(request, context) then
        result = node_result
      end
      increment_context_for_next_loop(context)
    end
    result
  end

  def append_to_response( response, context )
    take_value(:list)
    take_value(:index, false)
    take_value(:count)

    each do |node|
      node.append_to_response(response, context)
      increment_context_for_next_loop(context)
    end
  end

  def each
    if list = @values[:list] then
      if Hash === list then
        list.each_with_index do |item, index|
          set_value(:key, item[0])
          set_value(:item, item[1])
          set_value(:index, index) if @values[:index]
          yield @node
        end
      else
        index = 0
        list.each do |item|
          set_value(:item, item)
          set_value(:index, index) if @values[:index]
          yield @node
          index += 1
        end
      end
    elsif @values[:count] then
      @values[:count].times do |index|
        set_value(:index, index) if @values[:index]
        yield @node
      end
    end
  end

end

end
