module CGIKit

class Radio < DynamicElement
  class << self
    def create_api
      api = API.new(:Radio)
      api << name_binding()
      api << checked_binding()
      api << selection_binding()
      api << value_binding(false, false)
      api << enabled_binding()
      api << required_validation([:checked, :value])
      api << universal_validation(:value, :selection)
      api
    end

    def keys_to_delete_from_associations
      [:type]
    end
  end

  DEFAULT_VALUE = '1'

  def begin_context( context )
    take_value(:name)
    context.increment
    context.append_zero
    context.increment(@values[:name])
  end

  def end_context( context )
    context.delete
  end

  def take_values_from_request( request, context )
    take_bool(:checked)
    take_value(:value)
    take_value(:selection)

    if value = value_from_request(request, context) then
      if declared?(:checked) then
        set_value(:checked, true)
      elsif value == @values[:value] then
        set_value(:selection, @values[:value])
      end
    elsif context.current_form?(request) then
      if declared?(:checked) then
        if @values[:checked] == true then
          set_value(:checked, false)
        end
      else
        if @values[:value] == @values[:selection] then
          set_value(:selection, nil)
        end
      end
    end
  end

  def append_to_response( response, context )
    take_bool(:checked)
    take_value(:value)
    take_value(:selection)

    html = "<input type=\"radio\" name=\"#{name_value(context)}\""
    if @values[:value] then
      @values[:value] = escaped_string(@values[:value])
    end
    html << %Q' value="#{@values[:value] || DEFAULT_VALUE}"'
    if declared?(:checked) then
      if @values[:checked] == true then
        html << checked()
      end
    elsif @values[:selection] and (@values[:value] == @values[:selection]) then
      html << checked()
    end
    html << other()
    html << enabled()
    html << '/>'
    response.content << html
  end
end

end
