module CGIKit

class Frame < DynamicElement

  class << self
    def create_api
      api = API.new(:Frame)
      api << page_binding()
      api << src_binding()
      api << value_binding(false)
      api << required_validation([:page, :src, :value])
      api
    end
  end

  def begin_context( context )
    context.increment
  end

  def invoke_action( request, context )
    result = nil
    if context.action?(request) then
      result = context.session.component(context.context_id)
    end
    result
  end

  def append_to_response( response, context )
    take_value(:src)

    src = nil
    if @values[:src] then
      src = values[:src]
    else
      src = context.url(context.request.request_handler_key)
    end
    html =  "<frame src=\"#{src}\""
    html << other()
    html << "/>"
    response.content << html

    # the reason is if a browser accesses each frames concurrently,
    # context IDs may be repeated.
    generate_and_register_components(context)
  end

  def generate_and_register_components( context )
    if declared?(:page) or declared?(:value) then
      if declared?(:page) then
        take_value(:page)
        page = application.page(@values[:page], context)
      elsif declared?(:value) then
        page = value(:value)
      end
      session = context.session
      session.save_page(page)
      component_id = session.component_id(page)
      session.frame_components[context.context_id] = component_id
    end
  end

end

end
