module CGIKit

class Form < DynamicElement

  MULTIPART_FORM_DATA = "multipart/form-data"

  class << self
    def create_api
      api = API.new(:Form)
      method = Binding.new(:method)
      method.default = 'POST'
      enctype = Binding.new(:enctype)
      query = Binding.new(:query)
      query.default = :'{}'
      upload = Binding.new(:upload)
      upload.value_set = Binding::BOOLEAN
      upload.default = false
      action = Binding.new(:action)

      api << method
      api << enctype
      api << href_binding()
      api << query
      api << upload
      api << action
      api << name_binding()
      api << session_id_binding()
      api << existential_validation(:href, :action)
      api << existential_validation(:enctype, :upload)
      set_direct_action(api)
      api
    end
  end

  attr_accessor :has_action_in_container

  def init
    @has_action_in_container = false
  end

  def notify_existing_action_in_container
    @has_action_in_container = true
  end

  def begin_context( context )
    take_value(:name)
    unless direct_action? then
      context.session.save_page(@root)
      context.component_id = context.session.component_id(@root)
    end
    context.increment
    context.append_zero
    context.in_form = true
  end

  def end_context( context )
    context.delete
    context.in_form = false
  end

  def take_values_from_request( request, context )
    @node.take_values_from_request(request, context)
  end

  def invoke_action( request, context )
    take_value(:action, false)
    before = context.context_id
    result = @node.invoke_action(request, context)
    if !@has_action_in_container and \
      context.action?(request, before) and @values[:action] then
      result = @root[@values[:action]]
    end
    result
  end

  def append_to_response( response, context )
    take_value(:method)
    take_value(:enctype)
    take_value(:href)
    take_value(:query)
    take_bool(:upload)
    take_value(:session_id)
    take_value(:direct_action, false)
    take_value(:action_class)

    unless (@values[:method].downcase == 'post') or \
           (@values[:method].downcase == 'get') then
      @values[:method] = 'post'
    end
    if @values[:upload] == true then
      @values[:enctype] = MULTIPART_FORM_DATA
    end

    html =  "<form name=\"#{name_value(context)}\" method=\"#{@values[:method]}\""
    if @values[:href] then
      html << " action=\"#{@values[:href]}\""
    elsif direct_action? then
      url = context.direct_action_url(@values[:action_class],
                                      @values[:direct_action],
                                      {},
                                      @values[:session_id])
      html << " action=\"#{url}\""
    else
      url = context.component_action_url()
      html << " action=\"#{url}\""
    end
    if @values[:enctype] then
      html << " enctype=\"#{@values[:enctype]}\""
    end

    html << other()
    html << ">\n"
    if @values[:query] then
      html << hidden_fields(@values[:query])
    end
    response.content << html

    @node.append_to_response(response, context)
    response.content << "\n</form>\n"
  end

  def hidden_fields( query )
    fields = ''
    query.each do | key, value |
      value = Utilities.escape_html(value.to_s)
      fields << \
        "<input type=\"hidden\" name=\"#{key}\" value=\"#{value}\"/>\n"
    end
    fields
  end
end

end
