module CGIKit

# == URLs to invoke methods
# ../App.cgi/d/::            default_action on class "DirectAction"
# ../App.cgi/d/search::      search_action on class "DirectAction" or
#                            default_action on class "search"
# ../App.cgi/d/Data/search:: search_action on class "Data"
class DirectAction
  include KeyValueCoding

  DEFAULT_ACTION_NAME = 'default'
  ACTION_TEXT = '_action'
  SWEEP_ACTION_NAME = '__sweep_sessions'
  SWEEP_PASS_KEY = 'pass'
  SWEEP_PROOF = '<!-- CGIKit::DirectAction#__sweep_sessions -->'
  SWEEP_DELETED_START = '<!-- SWEEP_DELETED_START -->'
  SWEEP_DELETED_END   = '<!-- SWEEP_DELETED_END -->'
  SWEEP_FAILED_START = '<!-- SWEEP_FAILED_START -->'
  SWEEP_FAILED_END   = '<!-- SWEEP_FAILED_END -->'

  attr_reader :context, :request, :application

  def initialize( application, request )
    @application = application
    @request = request
    @context = @application.context_class.new(@request, @application)
    @handler = @application.direct_action_request_handler
  end


  #
  # accessing
  #

  def session
    unless @session then
      unless @session = existing_session then
        @session = @application.session_class.new
      end
    end
    @session
  end

  def existing_session
    unless session_id = session_id(@request) then
      return nil
    end
    session = @application.restore_session(session_id, @context)
    if session.nil? or session.terminate? then
      nil
    else
      session
    end
  end

  def session_id( request )
    @handler.session_id(request)
  end

  def page( name )
    @application.page(name, @context)
  end

  def key_for_action( action )
    action + ACTION_TEXT
  end

  def default_action_name
    DEFAULT_ACTION_NAME
  end


  #
  # performing
  #

  def perform_action( action )
    value_for_key(key_for_action(action))
  end

  def default_action
    page(@application.main)
  end


  #
  # testing
  #

  def direct_action?( action )
    respond_to?(key_for_action(action))
  end

  def self.sweep_page?( content )
    /#{SWEEP_PROOF}/ === content
  end


  #
  # taking form values
  #

  def take_form_values( keys )
    keys.each do |key|
      value = @request.form_value(key)
      take_value_for_key(key, value)
    end
  end

  def take_form_value_arrays( keys )
    keys.each do |key|
      value = @request.form_values[key]
      take_value_for_key(key, value)
    end
  end


  #
  # sweeping
  #

  def __sweep_sessions_action
    response = Response.new
    if @application.sweep_password then
      response.content = <<EOF
<html><head><title>Sweep Sessions</title></head><body>
#{SWEEP_PROOF}<form method="POST">
<input type="password" name="#{SWEEP_PASS_KEY}"/><input type="submit" value="Sweep"/>
</form>
EOF
      pass = @request.form_value('pass')
      if pass == @application.sweep_password then
        successed, failed = @application.session_store.sweep_sessions
        response.content << <<EOF
<p><strong>Deleted: #{SWEEP_DELETED_START}#{successed}#{SWEEP_DELETED_END}, 
Failed: #{SWEEP_FAILED_START}#{failed}#{SWEEP_FAILED_END}</p>
EOF
      end
      response.content << "</body></html>"
    end
    response
  end

  def self.sweep_info( content )
    /#{SWEEP_DELETED_START}([0-9]+)#{SWEEP_DELETED_END}/ === content
    deleted = $1
    /#{SWEEP_FAILED_START}([0-9]+)#{SWEEP_FAILED_END}/ === content
    failed = $1
    [deleted, failed]
  end

end

end
