module CGIKit

class DeclarationStore
  class DeclarationError < StandardError #:nodoc:
  end

  class << self
    def new_with_file( filename, source = nil )
      hash = nil
      str = nil
      open(filename) { |f| str = f.read }
      Thread.start(str) do
        $SAFE = 4
        hash = eval(str)
      end.join
      hash ||= {}
      merge_source(source, hash) if source
      new_from_hash(hash)
    end

    def merge_source( source, destination )
      source.each do |decname, dechash|
        if destination.key?(decname) then
          dechash.each do |attrname, attrvalue|
            unless destination[decname].key?(attrname) then
              destination[decname][attrname] = attrvalue
            end
          end
        else
          destination[decname] = dechash
        end
      end
    end

    def new_from_hash( hash )
      decs = new
      hash.each do |name, values|
        decs[name] = Declaration.new_from_hash(name, values)
      end
      decs.original_hash = hash
      decs
    end
  end

  attr_accessor :declarations, :original_hash

  def initialize
    @declarations = {}
  end

  def []( key )
    @declarations[key]
  end

  def []=( key, declaration )
    @declarations[key] = declaration
  end

  def each
    @declarations.each do |key, declaration|
      yield key, declaration
    end
  end

  def keys
    @declarations.keys
  end

  def validate_api( component_class = nil )
    msg = "Found validation errors in \"#{component_class}\"."
    error = ValidationError.new(msg)
    keys = @declarations.keys
    keys.map! {|key| key.to_s}
    keys.sort.each do |key|
      dec = @declarations[key.intern]
      if api = dec.element_type.api then
        errors = api.validate(dec.association_hash, component_class, key)
        if errors then
          error << errors
        end
      end
    end

    unless error.errors.empty? then
      raise error
    end
  end

end


# A Declaration object has a declaration set.
#
#  ex)
#  :BindingName => {
#    :element => String,        # element type (class)
#    :value => :'method.chain', # symbol value is dealt as method chain
#    :empty => false            # other value is dealt as constant value
#  }
#    
class Declaration
  attr_accessor :element_name, :element_type, :association_hash

  ELEMENT_KEY  = :element
  OTHER_KEY    = :other
  VALIDATE_KEY = :validate
  PASS_KEY     = :pass
  ENABLED_KEY  = :enabled

  class << self
    def new_from_hash( name, hash )
      unless hash.key?(ELEMENT_KEY) then
        raise "'#{name}' don't define #{ELEMENT_KEY.inspect}."
      end
      dec = Declaration.new(name, hash[ELEMENT_KEY])
      ass = nil
      hash.each do |key, value|
        if Symbol === value then
          ass = Association.new_with_keypath value
        else
          ass = Association.new_with_value value
        end
        dec[key] = ass
      end
      dec
    end
  end

  def initialize( name, type )
    @element_name = name
    @element_type = type
    @association_hash = {}
  end

  def []( name )
    @association_hash[name]
  end

  def []=( name, value )
    @association_hash[name] = value
  end

  def each
    @association_hash.each do |key, as|
      yield key, as
    end
  end
end

end
