module CGIKit

# new_with_keypath, new_with_value
# constant?(component=nil), settable?(component=nil)
# set_value(value, component), value(component)

class Association
  class InternalInconsistencyError < StandardError #:nodoc:
  end

  attr_accessor :keypath
  attr_accessor :_value, :_constant #:nodoc:

  class << self
    def new_with_keypath( keypath )
      as = Association.new
      as.keypath = keypath
      as._constant = false
      as
    end

    def new_with_value( value )
      as = Association.new
      as._value = value
      as._constant = true
      as
    end

    def adapt_to_bool(value)
      if (value == false) or value.nil? or \
        (value == 0) or (value == 'false') then
        false
      else
        true
      end
    end
  end

  def constant?
    _constant == true
  end

  def constant_in_component?( component )
    if _constant == true then
      return false
    else
      return (component.can_set_value?(@keypath) == false)
    end
  end

  def settable?
    _constant != true
  end

  def settable_in_component?( component )
    if _constant == true then
      return false
    else
      return component.can_set_value?(@keypath)
    end
  end

  def set_value( value, component )
    if settable? then
      component.take_value_for_keypath(keypath, value)
    else
      raise InternalInconsistencyError, "The receiver's value is not settable."
    end
  end

  def value( component = nil )
    if constant? then
      _value
    elsif component.nil? then
      keypath
    else
      component.value_for_keypath(keypath)
    end
  end

  # Returns false if - null, false, 0, "false"
  def bool( component = nil )
    value = value(component)
    Association.adapt_to_bool(value)
  end

end

end
