#!/usr/bin/ruby

$LOAD_PATH.unshift('../')

require 'cgikit'
require 'kconv'

class DiaryManager
  
  def initialize(dir)
    @dir = File.expand_path(dir)
  end
  
  def get_diaries(date)
    a = []
    
    if /^(\d{4})(\d{2})$/ =~ date
      Dir.glob("#{@dir}/#{$1}/#{$2}/*.txt").each do |i|
        if FileTest.readable?(i)
          File.open(i) do |f|
            a << [File.basename(i, '.txt'), Kconv.toutf8( f.read )]
          end
        end
      end
    else
      nil
    end
    
    a.sort!{|i,j| i[0] <=> j[0]}
    a
  end
  
  def get_diary(date)
    s = nil
    if /^(\d{4})(\d{2})(\d{2})$/ =~ date
      begin
        File.open("#{@dir}/#{$1}/#{$2}/#{date}.txt") do |f|
          s = Kconv.toutf8(f.read)
        end
      rescue Errno::ENOENT
      end
    end
    
    [date, s]
  end
  
  def write_diary(string, y,m,d)
    unless FileTest.directory?("#{@dir}/#{y}")
      Dir.mkdir(y)
    end   
    unless FileTest.directory?("#{@dir}/#{y}/#{m}")
      Dir.mkdir("#{@dir}/#{y}/#{m}")
    end
    
    # Need Lock
    File.open("#{@dir}/#{y}/#{m}/#{y}#{m}#{d}.txt", "w") do |f|
      f.write( Kconv.toutf8(string) )
    end
  end
  
  def get_recent_file(num)
    a = []
    
    Dir.glob("#{@dir}/[0-9][0-9][0-9][0-9]").each do |year|
      (1..12).to_a.reverse!.each do |m|
        a = a + Dir.glob( (year + '/%02d/*.txt'%m) )
        if a.size > num
          a.sort!
          return a[(-num)..-1]
        elsif a.size == num
          a.sort!
          return a
        end
      end
    end
    
    a
  end
  
  def get_recent_diaries(num)
    arr = get_recent_file(num)
    a = []
    
    arr.each do |name|
      File.open(name) do |f|
        a << [File.basename(name, '.txt'), Kconv.toutf8(f.read)]
      end
    end
    
    a.reverse!
  end
  
end

class DiaryAction < CGIKit::DirectAction
  
  def day_action
    page = page(DayPage)
    date = self.request.form_value('d').to_s
    
    m = DiaryManager.new('.')
    page.diary = m.get_diary(date)
    
    page.date = date
    page
  end
  
  def month_action
    page = page(MonthPage)
    date = self.request.form_value('d').to_s
    
    m = DiaryManager.new('.')
    page.diaries = m.get_diaries(date)
    
    page.date = date
    page
  end
  
  def recent_action
    page = page(MonthPage)
    
    m = DiaryManager.new('.')
    page.diaries = m.get_recent_diaries(3)
    
    page.date = Time.now.strftime("%Y%m")
    page
  end
  
  alias default_action recent_action
  
end

class FramePage < CGIKit::Component
  
  def title
    'hoge diary'
  end
  
  def write_link
    File.join( File.dirname(@application.baseurl), 'DiaryPost.rb')
  end
  
end

class DiaryPage < CGIKit::Component
  
  attr_accessor :sec_list, :i
  attr_reader :diary
  
  def diary=(diary)
    @date = diary[0]
    if diary[1].nil?
      @sec_list = []
      return
    end
    
    sec = diary[1].split(/\r?\n\r?\n/)
    
    list = []
    sec.each do |i|
      if /^#(.*)#(.*)/m =~ i
        list << {'title' => $1, 'content' => $2}
      else
        list << {'title' => '', 'content' => i}
      end
    end
    
    @sec_list = list
  end
  
  def get_date
    @date.to_s
  end
  
  def get_sec_title
    @i['title']
  end
  
  def get_content
    @i['content']
  end
  
end


module DiaryDate
  attr_accessor :date  
end

class DayPage < CGIKit::Component
  include DiaryDate
  def diary=(diary)
    @diary = diary
  end
end

class PlueralPage < CGIKit::Component
  
  include DiaryDate
  
  attr_accessor :diaries, :j
  
end

class MonthPage < PlueralPage
  
  def latest_link
    @application.baseurl
  end
  
  def next_link
    if /^(\d{4})(\d{2})$/ =~ @date
      t = Time.gm($1.to_i, $2.to_i) + 2678400
      @application.baseurl + '/d/month?d=' + t.strftime('%Y%m')
    else
      @application.baseurl
    end
  end
  
  def prev_link
    if /^(\d{4})(\d{2})$/ =~ @date
      t = Time.gm($1.to_i, $2.to_i) - 2419200
      @application.baseurl + '/d/month?d=' + t.strftime('%Y%m')
    else
      @application.baseurl
    end\
  end
  
end

class RecentPage < PlueralPage
end


if $0 == __FILE__
  app = CGIKit::Application.new
  app.direct_action_class = DiaryAction
  app.default_request_handler = app.direct_action_request_handler
  app.run
end

