#!/usr/bin/ruby

$LOAD_PATH.unshift('../')

require 'cgikit'
require 'blog'

class DiaryPost < CGIKit::Component

  attr_accessor :year, :month, :day, :content, :i
  
  def init
    t = Time.now

    @year = t.year.to_s
    @month = '%02d' % t.month
    @day = '%02d' % t.day
    
    m = DiaryManager.new('.')
    @content = m.get_diary(@year + @month + @day)[1]
  end  
  
  MONTH2DAY = {
    1 => 31,
    2 => 28,
    3 => 31,
    4 => 30,
    5 => 31,
    6 => 30,
    7 => 31,
    8 => 31,
    9 => 30,
    10 => 31,
    11 => 30,
    12 => 31,
  }
    
  def reap_year?(y)
    if  y % 4 == 0
      if y % 100 == 0
        if y % 400 == 0
          true
        else
          false
        end
      else
        true
      end
    else
      false
    end
  end

  def write_and_disyplay_msg
    y = "%04d" % @year.to_i
    m = "%02d" % @month.to_i
    d = "%02d" % @day.to_i

    page = page(MessagePage)
    if valid?(y,m,d)
      dm = DiaryManager.new('.')
      dm.write_diary(@content,y,m,d)
      page.error = false
    else
      page.error = true
    end
    
    page    
	end
  
  def valid?(y,m,d)
    y = y.to_i
    m = m.to_i
    d = d.to_i
    
    if m == 2 and reap_year?(y)
      max = 29
    else
      max = MONTH2DAY[m]
    end
    
    ((d > 0) and (d <= max))
  end
  
  def edit
    page = page(self.class)
    page.year = @year
    page.month = @month
    page.day = @day
    
    y = "%04d" % @year.to_i
    m = "%02d" % @month.to_i
    d = "%02d" % @day.to_i
    
    if valid?(y,m,d)
      d = DiaryManager.get_diary(y + m + d)
      page.content = d[1]
    end
    page
  end
  
end

class MessagePage < CGIKit::Component
  attr_accessor :error
  
  def error_msg
    if @error
      'Error Occured'
    else
      'Written'
    end
  end
  
  def latest_link
    File.join( File.dirname(@application.baseurl), 'blog.rb')
  end
  
end


if $0 == __FILE__
	app = CGIKit::Application.new  
	app.main = DiaryPost
  app.validate_api = false
	app.run
end
