module ShowDisplay

  class Book

    attr_accessor :title, :author, :price

    def self.default_values
      {
        :title => 'No title',
        :author => 'John Doe',
        :price => 100
      }
    end

    def self.attribute_keys
      [:title, :author, :price]
    end

    def initialize( title = nil, author = nil, price = nil )
      @title = title
      @author = author
      @price = price
    end

  end

end

