module ShowDisplay

  class Application < CGIKit::Application

    def configure
      configure_component
      configure_session
      configure_paths
      configure_localization
      configure_request_handlers
      configure_classes
    end


    def configure_component

      # Main page:
      # If session ID or context ID aren't specified, this component is shown. 
      @main = ShowDisplay::MainPage

      # Error page:
      # Name or class of an error page component to show caught errors.
      @error_page = CGIKit::CKErrorPage

      # Cache template:
      # Whether or not caches templates to reduce parsing load.
      @cache_template = true

      # Validating API of elements:
      # Whether or not validates setting of attributes for each elements.
      # If wrong attribute name or combination are found, raises error.
      @validate_api = true

    end


    def configure_session

      # Page cache size:
      # Size to cache components permanently in session.
      # Newly generated page is cached automatically.
      # If holded page size is over the value, oldest pages are deleted.
      @page_cache_size = 30

      # Permanent page cache size:
      # Size to cache components permanently in session.
      # Permanent page cache is cached optionally, not automatically caching.
      # If holded page size is over the value, oldest pages are deleted.
      @permanent_page_cache_size = 30

      # Session timeout:
      # Seconds until the session has timed out.
      @timeout = 60 * 60 * 24 * 7

      # Session cookie expires:
      # Expiry date of cookie for session. If you set the value to nil,
      # session cookies will be invalid when closing browser.
      @session_cookie_expires = 60 * 60 * 24 * 7

      # Storing session IDs in URLs:
      # Enables or disables the use of URLs for storing session IDs.
      @store_in_url = true

      # Storing session IDs in cookies:
      # Enables or disables the use of cookies for storing session IDs.
      @store_in_cookie = false

      # Authorizing session by user agent:
      # Enables or disables session authorization by browsers.
      # If you set the value to true, the application raises error
      # when an user accesses it with browser that is different from
      # one registered session.
      @auth_by_user_agent = false

      # Authorizing session by IP addresses:
      # Enables or disables session authorization by IP addresses.
      # If you set the value to true, the application raises error
      # when an user accesses it with IP address that is different from
      # one registered session.
      @auth_by_remote_addr = false

      # Session key:
      # This key is used in cookie.
      @session_key = '_session_id'

      # Session key in direct action:
      # This key is used in hidden fields of form and URL when using direct action.
      @direct_action_session_key = '_sid'

    end


    def configure_paths

      # Component paths:
      # The file system paths for components. Components are searched under it.
      #
      # The default value is an array of these paths.
      #
      # * ShowDisplay/
      # * ShowDisplay/components
      # * (each load paths for library)/cgikit/components
      #
      @component_paths = ['./components', Dir.pwd]
      $LOAD_PATH.each do |path|
        @component_paths << File.join(path, CGIKIT_LIB, COMPONENT_LIB)
      end

      # Document root directory:
      # @document_root = '/var/www/htdocs'

      # Resources directory:
      # This directory includes files to be used by the application,
      @resources = './resources'

      # Web server resources directory:
      # This directory includes files to be displayed to browser.
      # The files are used by Image element, etc.
      # @web_server_resources = '/var/www/htdocs/images'

      # Temporary directory:
      # Temporary directory to be used by the framework.
      # The framework uses this to store sessions and template caches.
      @tmpdir = './tmp' || ENV['TMP'] || ENV['TEMP']

    end


    def configure_localization

      # Encoding for form data:
      # Encoding to encode character code of form data.
      # The default implementation does nothing.
      # If you use Japanese encoding, require 'cgikit/lang/ja'.
      # Or if you want to use other encoding, implement custom encoding
      # by overwriting DynamicElement#encode_string and failed_encode_string.
      # @encoding = nil

      # Master locale.
      # Main locale of an application. If the value is equal to
      # locale specified in request, components use templates whose name
      # doesn't include the locale name. If the value is
      # "ja", requested locale is "ja" and the component name is "MainPage",
      # the application uses templated named "MainPage.html".
      # @master_locale = 'ja'

    end


    def configure_classes

      # Direct action class:
      @direct_action_class = ShowDisplay::DirectAction

      # Session class:
      @session_class = ShowDisplay::Session

      # Context class:
      # @context_class = CGIKit::Context

      # HTML parser class:
      # @htmlparser_class = CGIKit::HTMLParser::HTMLParser

    end


    def configure_request_handlers

      # Component request handler key:
      # @component_request_handler_key = 'c'

      # Direct action request handler key:
      # @direct_action_request_handler_key = 'd'

      # Resource request handler key:
      # @resource_request_handler_key = 'r'

      # Component request handler:
      # @component_request_handler = CGIKit::ComponentRequestHandler.new(self)

      # Direct action request handler:
      # @direct_action_request_handler = CGIKit::DirectActionRequestHandler.new(self)

      # Resource request handler:
      # @resource_request_handler = ResourceRequestHandler.new(self)

      # Default request handler:
      # This handler is used when the application receives a request
      # without request handler key.
      # If you set the value to direct action request handler,
      # the application invoke default direct action when first accessing it.
      # The default value is component request handler.
      # @default_request_handler = @component_request_handler

    end

  end

end
