class MainPage < CGIKit::Component
  
  attr_reader :filename
  
  def init
    opt = application.log_options
    @filename = opt['file']
    @max_file_size = opt['max_file_size']
    @progname = opt['name']
    
    @log = Logger.new(@filename, @max_file_size)
    @log.progname = @progname
  end
  
  def max_file_size
    @max_file_size
  end
  
  def will_save_page
    @log = nil
  end

  def did_restore_page
    @log = Logger.new(@filename, @max_file_size)
    @log.progname = @progname
  end

  def raise_error
    1 + nil
  end

  def content_log_file
    s = nil
    File.open(@filename) do |f|
      s = f.read
    end
    s
  end

  def debug
    @log.debug "debug level message."
  end

  def info
    @log.info "info level message."
  end

  def warn
    @log.warn "warn level message."
  end

  def error
    @log.error "error level message."
  end

  def fatal
    @log.fatal "fatal level message."
  end

end


