module CKWiki

class Context < CGIKit::Context
  include CGIKit

  DISPLAY_ACTION = 'display'
  EDIT_ACTION = 'edit'
  RECENT_ACTION = 'recent'
  RSS_ACTION = 'rss'

  def wiki_url( name, body = nil )
    unless body then
      body = name
    end
    query = {DirectAction::NAME_KEY => name}
    if @application.page_index.has_name?(name) then
      url = direct_action_url(nil, 'display', query)
      "<a href=\"#{url}\">#{body}</a>"
    else
      url = direct_action_url(nil, 'edit', query)
      "<a href=\"#{url}\">?</a>#{body}"
    end
  end

  def display_url( name )
    query = {DirectAction::NAME_KEY => name}
    direct_action_url(nil, DISPLAY_ACTION, query, false)
  end

  def recent_url
    direct_action_url(nil, RECENT_ACTION, {}, false)
  end

  def rss_url
    direct_action_url(nil, RSS_ACTION, {}, false)
  end

end

end
