module CKWiki

  FRONT_PAGE    = 'FrontPage'
  HELP_PAGE     = 'HelpPage'
  UPLOAD_INDEX  = 'UploadIndex'
  PAGE_INDEX    = 'PageIndex'
  RECENT_INDEX  = 'RecentIndex'
  INVERSE_PAGE_INDEX = 'InversePageIndex'
  INDEX_NAMES = [UPLOAD_INDEX, PAGE_INDEX, RECENT_INDEX, INVERSE_PAGE_INDEX]

  class Application < CGIKit::Application
    include CGIKit

    attr_accessor :css, :wikiname, :summary_length, :cvspath, :cvs, :lang, \
    :rss_page_number
    alias cvs? cvs

    def self.index_names
      INDEX_NAMES
    end

    def init
      @session_class = CKWiki::Session
      @context_class = CKWiki::Context
      @direct_action_class = CKWiki::DirectAction
      @summary_length = 160
      @cvspath = %x(which cvs).chomp
      @cvs = false
      @lang = 'en'
      @rss_page_number = 10
    end

    def wiki_page( name )
      WikiPage.new_with_resource_manager(name, @resource_manager)
    end

    def upload_index
      @upload_index ||= UploadIndex.new_with_application(self)
    end

    def page_index
      @page_index ||= PageIndex.new_with_application(self)
    end

    def recent_index
      @recent_index ||= RecentIndex.new_with_application(self)
    end

    def inverse_page_index
      @inverse_page_index ||= InversePageIndex.new_with_application(self)
    end

    def entry_store
      @entry_stroe ||= CVSEntryStore.new(@resources)
    end

  end

end
