module CKWiki

class HeaderParts < CGIKit::Component
  include Utilities

  attr_accessor :page_name, :links_edit, :links_file_upload, :links_list, :links_recent, :links_top, :links_help, :links_diff

  def init
    @links_edit = true
    @links_diff = false
    @links_file_upload = true
    @links_list = true
    @links_recent = true
    @links_top = true
    @links_help = true
    @links_search = true
  end

  def css
    resource_manager.url(application.css)
  end

  def edit_page
    page = page(EditPage)
    page.init_editing_page(@page_name)
    page
  end

  def diff_page
    page = page(DiffPage)
    page.page_name = @page_name
    page
  end

  def help_page
    display_page_with_name(HELP_PAGE)
  end

  def search
    page = page(SearchPage)
    page.search(keyword)
    page
  end

end

end
