//#include "cfc.h"
#include "tokugi.h"

int Tokugi::_totalInitialLevel = 0;
int Tokugi::_totalExperimentalLevel = 0;

Tokugi::Tokugi()
    :Data(),
    _property(7,NULL),
    _initialLevel(0),
    _experimentalLevel(0)
{

}

Tokugi::Tokugi(QString name, Data* data)
    :Data(),
    _property(7,NULL),
    _initialLevel(0),
    _experimentalLevel(0)
{
    SetName(name);
    SetParent(data);
}

Tokugi::~Tokugi()
{

}

bool Tokugi::SetName(QString name)
{
    _property[0] = name;
    return true;
}

QString Tokugi::GetName()
{
    return _property.value(0);
}

QString Tokugi::GetReference()
{
    return _property.value(1);
}
bool Tokugi::SetReference(QString reference)
{
    _property[1] = reference;
    return true;
}
QString Tokugi::GetType()
{
    return _property.value(2);
}
bool Tokugi::SetType(QString type)
{
    _property[2] = type;
    return true;
}
QString Tokugi::GetCapability()
{
    return _property.value(3);
}
bool Tokugi::SetCapability(QString capability)
{
    _property[3] = capability;
    return true;
}
QString Tokugi::GetTiming()
{
    return _property.value(4);
}
bool Tokugi::SetTiming(QString timing)
{
    _property[4] = timing;
    return true;
}
QString Tokugi::GetCost()
{
    return _property.value(5);
}
bool Tokugi::SetCost(QString cost)
{
    _property[5] = cost;
    return true;
}
QString Tokugi::GetDetail()
{
    return _property.value(6);
}
bool Tokugi::SetDetail(QString detail)
{
    _property[6] = detail;
    return true;
}
bool Tokugi::AddDetail(QString detail)
{
    _property[6].append(detail);
    return true;
}

QVector<QString> Tokugi::GetProperty()
{
    return _property;
}

int Tokugi::GetTotalInitialLevel()
{
    return _totalInitialLevel;
}

int Tokugi::GetTotalExperimentalLevel()
{
    return _totalExperimentalLevel;
}

int Tokugi::GetInitialLevel()
{
    return _initialLevel;
}

bool Tokugi::IncreaseInitialLevel()
{
    _initialLevel ++;
    _totalInitialLevel ++;
    return true;
}
bool Tokugi::DecreaseInitialLevel()
{
    _initialLevel --;
    _totalInitialLevel --;
    return true;
}

int Tokugi::GetExperimentalLevel()
{
    return _experimentalLevel;
}
bool Tokugi::IncreaseExperimentalLevel()
{
    _experimentalLevel ++;
    _totalExperimentalLevel ++;
    return true;
}
bool Tokugi::DecreaseExperimentalLevel()
{
    _experimentalLevel --;
    _totalExperimentalLevel --;
    return true;
}
