#ifndef OWNCORONAFORM_H
#define OWNCORONAFORM_H

#include <QWidget>
#include <QTableWidget>
#include "corona.h"
#include "meme.h"
#include "branch.h"
#include "tokugi.h"

namespace Ui {
    class OwnCoronaForm;
}

class OwnCoronaForm : public QWidget
{
    Q_OBJECT

public:
    explicit OwnCoronaForm(QWidget *parent = 0);
    virtual ~OwnCoronaForm();

    bool addCategory(QTableWidget*, Data*);
    bool removeCategory(QTableWidget* qtw, QList<Data*> list, int num);
    bool addTokugi(Data* tokugi);
    bool removeTokugi(Data* parent);
    bool setOwnGeneral(Data* ownGeneral);
    bool setTableResize();
    bool getAutoGottenTokugi(Data* ownParent);

    QList<Data*> GetOwnCoronaList();
    QList<Data*> GetOwnMemeList();
    QList<Data*> GetOwnBranchList();
    QList<Data*> GetOwnTokugiList();
    Data* GetMainMeme();
    Data* GetMainBranch();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::OwnCoronaForm *ui;
    Data* _ownGeneral;
    QList<Data*> _ownCorona;
    QList<Data*> _ownMeme;
    QList<Data*> _ownBranch;
    QList<Data*> _ownTokugiList;
    Data* _mainMeme;
    Data* _mainBranch;

signals:
    void removeCorona(Data*);
    void removeMeme(Data*);
    void removeBranch(Data*);

public slots:
    //from CoronaWindow
    void GetSelectedCorona(Data *corona);
    void GetSelectedCoronaTokugi(Data* tokugi);

    //from MemeWindow
    void GetSelectedMeme(Data*meme);
    void GetSelectedBranch(Data*branch);
    void GetSelectedMemeTokugi(Data* tokugi);
    void GetSelectedBranchTokugi(Data* tokugi);

private slots:
    void resizeEvent(QResizeEvent *);
    void on_tableWidget_2_cellClicked(int row, int column);
    void on_comboBox_currentIndexChanged(int index);
    void on_comboBox_2_currentIndexChanged(int index);
    //コロナ取消
    void on_pushButton_clicked();
    //特技取消
    void on_pushButton_2_clicked();
    //ミーム取消
    void on_pushButton_3_clicked();
    //ブランチ取消
    void on_pushButton_4_clicked();
};
#endif // OWNCORONAFORM_H
