#include "owncoronaform.h"
#include "ui_owncoronaform.h"
#include <QDebug>
#include <QTextCodec>
#include <QMessageBox>

OwnCoronaForm::OwnCoronaForm(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::OwnCoronaForm),
    _ownGeneral(NULL),
    _ownCorona(),
    _ownMeme(),
    _ownBranch(),
    _ownTokugiList(),
    _mainMeme(NULL),
    _mainBranch(NULL)
{
    ui->setupUi(this);
}

OwnCoronaForm::~OwnCoronaForm()
{
    delete ui;
}

void OwnCoronaForm::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

/**
  * 入力：テーブルウィジェット、追加したいデータ、カテゴリ
  *　結果：テーブルウィジェットの表示にカテゴリ追加
  */
bool OwnCoronaForm::addCategory(QTableWidget *qtw, Data *data)
{
    // 一番左上が空白なら
    if(qtw->item(0,0)==NULL)
    {
	// 行を一つに
	qtw->setRowCount(1);
    }
    // そうでないなら
    else
    {
	// 行を一つ増やす
	qtw->setRowCount(qtw->rowCount() + 1);
    }

    QTableWidgetItem* item = new QTableWidgetItem(data->GetName(), 0);
    qtw->setItem(qtw->rowCount()-1,0,item);

    int column_num = 1;

    if(data->GetKihonCapability() != QVector<int>())
    {
	for(int j=0;j<5;j++)
	{
	    //基本能力の表示
	    qtw->setItem(qtw->rowCount()-1,column_num,new QTableWidgetItem(QString::number(data->GetKihonCapability(j)), 0));
	    column_num++;
	}
    }
    if(data->GetSentouCapability() != QVector<int>())
    {
	for(int j=0;j<5;j++)
	{
	    //戦闘能力の表示
	    qtw->setItem(qtw->rowCount()-1,column_num,new QTableWidgetItem(QString::number(data->GetSentouCapability(j)), 0));
	    column_num++;
	}
    }
    return true;
}

/**
  * 入力：テーブルウィジェット、除去したいデータ
  *　結果：テーブルウィジェットの表示から選択カテゴリ除去
  */
bool OwnCoronaForm::removeCategory(QTableWidget *qtw, QList<Data*> list, int num)
{
    Data* data = list.at(num);
    if(data==NULL) // data が null のエラー回避
    {
	QMessageBox::warning(ui->tableWidget, "Warning", tr("データがありません") ,QMessageBox::Ok,QMessageBox::NoButton);
	return false;
    }
    // 所属特技除去
    foreach(Data* tokugi, _ownTokugiList)
    {
	if(tokugi->GetParent() == data)
	{
	    ui->tableWidget_2->removeRow(_ownTokugiList.indexOf(tokugi));
	    _ownTokugiList.removeOne(tokugi);
	}
    }
    list.removeAt(num);
    qtw->removeRow(qtw->currentRow());

    // 行が無くなったなら
    if(qtw->rowCount()==0)
    {
	// 行を一つ増やす
	qtw->setRowCount(1);
    }

    return true;
}

/**
  * 入力：所属、追加したい特技データ
  *　結果：テーブルウィジェットの表示にカテゴリ追加
  */
bool OwnCoronaForm::addTokugi(Data *tokugi)
{
    if(tokugi == NULL) // tokugi が null のエラー回避
    {
	QMessageBox::warning(ui->tableWidget, tr("Warning"), tr("特技がありません"),QMessageBox::Ok,QMessageBox::NoButton);
	return false;
    }

    Data* parent = tokugi->GetParent();
    // 特技なら
    if( (parent == NULL) )// data が null のエラー回避
    {
	QMessageBox::warning(ui->tableWidget, tr("Warning"), tr("特技が属しているものがありません"),QMessageBox::Ok,QMessageBox::NoButton);
	return false;
    }

    //所属元を取得していないならば
    if( (parent->IsOwned()==false) && (parent != _ownGeneral) )
    {
        QMessageBox::warning(ui->tableWidget,tr("Warning"), tr("特技が属しているものが取得されていません"), QMessageBox::Ok, QMessageBox::NoButton);
        return false;
    }

    if( parent != parent)
    {
	QMessageBox::warning(ui->tableWidget, tr("Warning"), tr("特技の所属が一致しません"),QMessageBox::Ok,QMessageBox::NoButton);
	return false;
    }

    // 所属列検索
    int baseColumn = -1;
    for(int k=0;k<ui->tableWidget_2->columnCount();k++)
    {
	if( ui->tableWidget_2->horizontalHeaderItem(k)->text().contains(QObject::tr("所属")) )
	{
	    baseColumn = k;
	    break;
	}
    }
    if(baseColumn==-1)
    {
	QMessageBox::warning(ui->tableWidget_2, QObject::tr("Warning"), QObject::tr("所属列が見つかりません"), QMessageBox::Ok, QMessageBox::NoButton);
	return false;
    }

    // 特技名列検索
    int nameColumn = -1;
    for(int k=0;k<ui->tableWidget_2->columnCount();k++)
    {
	if( ui->tableWidget_2->horizontalHeaderItem(k)->text().contains(QObject::tr("特技名")) )
	{
	    nameColumn = k;
	    break;
	}
    }
    if(nameColumn==-1)
    {
	QMessageBox::warning(ui->tableWidget_2, QObject::tr("Warning"), QObject::tr("所属列が見つかりません"), QMessageBox::Ok, QMessageBox::NoButton);
	return false;
    }

    // 初めて取得した特技の場合
    if(!tokugi->IsOwned())
    {
	_ownTokugiList.append(tokugi);
	parent->OwnAdd(tokugi);
	tokugi->IncreaseInitialLevel();
	// 一番左上が空白なら
	if(ui->tableWidget_2->item(0,0)==NULL)
	{
	    // 行を一つに
	    ui->tableWidget_2->setRowCount(1);
	}
	// そうでないなら
	else
	{
	    // 行を一つ増やす
	    ui->tableWidget_2->setRowCount(ui->tableWidget_2->rowCount() + 1);
	}

	// 所属の表示 順番の柔軟性を持たせたいのだが
	ui->tableWidget_2->setItem(ui->tableWidget_2->rowCount()-1, baseColumn, new QTableWidgetItem(tokugi->GetParent()->GetName(),0) );

	QVector<QString> property = tokugi->GetProperty();

	// 特技のレベル"1"を表示
	QString q = property.at(0);
	q.append("[1/1]");
	ui->tableWidget_2->setItem(ui->tableWidget_2->rowCount()-1 , nameColumn, new QTableWidgetItem(q, 0) );
	for(int j=1;j<property.size();j++)
	{
	    ui->tableWidget_2->setItem(ui->tableWidget_2->rowCount()-1 ,j+1, new QTableWidgetItem(property.at(j), 0));
	}
    }
    // 既に取得している特技のレベルを上げる場合
    else
    {
	//初期特技点分のレベルアップ
	tokugi->IncreaseInitialLevel();

	/*
		//経験点分のレベルアップ
		otokugi->IncreaseExperimentalLevel();
		*/
	QString tokugiName = tokugi->GetName();
	tokugiName.append("\\[(\\d)+/(\\d)+\\]");
	QList<QTableWidgetItem*> q = ui->tableWidget_2->findItems(tokugiName, Qt::MatchRegExp);

	int row = q.at(0)->row();
	QString initialLevel = QString::number( tokugi->GetInitialLevel() );
	QString totalLevel = QString::number( tokugi->GetInitialLevel() + tokugi->GetExperimentalLevel() );
	ui->tableWidget_2->setItem(row, nameColumn, new QTableWidgetItem(tokugi->GetName().append("[").append(initialLevel).append("/").append(totalLevel).append("]"), 0 ) );
    }
    return true;
}

/**
  _ownGeneralの設定
  */
bool OwnCoronaForm::setOwnGeneral(Data *ownGeneral)
{
    _ownGeneral = ownGeneral;
    return true;
}

/**
  テーブルウィジェットを各内容に対応する幅になるよう設定
  */
bool OwnCoronaForm::setTableResize()
{
    ui->tableWidget->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    ui->tableWidget_2->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    ui->tableWidget_3->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    ui->tableWidget_4->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    return true;
}

/**
 自動取得特技
 input : OwnData*(取得特技所属データ)、QList<Tokugi*>
 ToDo 初期特技点や経験点の計算
*/
bool OwnCoronaForm::getAutoGottenTokugi(Data* ownParent)
{
    foreach(Data *tokugi, ownParent->getAutoGetTokugiList() )
    {
        addTokugi(tokugi);
    }

return true;
}

/**
  所属特技を取得特技欄から除去
  */
bool OwnCoronaForm::removeTokugi(Data *parent)
{
    if(_ownTokugiList.size()>0)
    {
        for(int i=0;i<_ownTokugiList.size();)
        {
            if(_ownTokugiList.at(i)->GetParent() == parent)
            {
                _ownTokugiList.removeAt(i);
                ui->tableWidget_2->removeRow(i);
            }
            else
            {
                ++i;
            }
        }
    }

    // 行が無くなったなら
    if(ui->tableWidget_2->rowCount()==0)
    {
        // 行を一つ増やす
        ui->tableWidget_2->setRowCount(1);
    }
    return true;
}

void OwnCoronaForm::GetSelectedCoronaTokugi(Data *tokugi) //slot
{
    addTokugi(tokugi);
}

void OwnCoronaForm::GetSelectedMemeTokugi(Data *tokugi) //slot
{
    addTokugi(tokugi);
}

void OwnCoronaForm::GetSelectedBranchTokugi(Data *tokugi) //slot
{
    addTokugi(tokugi);
}

/*
 slots
 */

/**
from CoronaWindow
コロナ取得
*/
void OwnCoronaForm::GetSelectedCorona(Data *selCorona) //slot
{
    // 選択コロナが取得コロナかチェック
    if(selCorona->IsOwned())
    {
	QMessageBox::warning(ui->tableWidget, tr("Warning"), tr("取得済みのコロナです"), QMessageBox::Ok,QMessageBox::NoButton);
	return;
    }

    // 異なっていた場合
    ui->tableWidget->clearContents();

    // 子取得特技を除去のため
    // コロナを取得している　かつ　取得コロナがデータを持っている場合
    if(_ownCorona.size()>0)
    {
        removeTokugi(_ownCorona.at(0));

        //取得コロナ除去
        emit removeCorona(_ownCorona.at(0));
        removeCategory(ui->tableWidget, _ownCorona, 0);
        _ownGeneral->OwnRemove(_ownCorona.takeFirst());
    }
    /*    foreach(Data* corona, _ownCorona)
    {
        _ownCorona.removeOne(corona);
	if(corona==NULL)
	{
	    continue;
	}
	_ownGeneral->OwnRemove(corona);
        //to PossibleTokugiForm
        emit removeCorona(corona);

        //所属特技の除去
	for(int i=0;i<_ownTokugiList.size();)
	{
	    if(_ownTokugiList.at(i)->GetParent() == corona)
	    {
		_ownTokugiList.removeOne(_ownTokugiList.at(0));
		ui->tableWidget_2->removeRow(i);
                break;
	    }
            ++i;
	}
    }
*/
    // 後に選択コロナを取得
    _ownCorona.append(selCorona);
    _ownGeneral->OwnAdd(selCorona);

    addCategory(ui->tableWidget, selCorona);

    // 自動取得特技
    getAutoGottenTokugi(selCorona);
}

/**
from MemeWindow::selectedMeme
ミーム取得
*/
void OwnCoronaForm::GetSelectedMeme(Data *selMeme) //slot
{
    if(selMeme == NULL)
    {
	QMessageBox::warning(ui->tableWidget, tr("Warning"), tr("何かミームを選択してください"), QMessageBox::Ok, QMessageBox::NoButton);
	return;
    }

    // 選択ミームが取得ミームかチェック
    if(selMeme->IsOwned())
    {
	QMessageBox::warning(ui->tableWidget, tr("Warning"), tr("取得済みのミームです"),QMessageBox::Ok,QMessageBox::NoButton);
	return;
    }
    // 異なっていた場合
    //ミーム取得
    _ownMeme.append(selMeme);
    _ownGeneral->OwnAdd(selMeme);
    addCategory(ui->tableWidget_3, selMeme);

    ui->comboBox->addItem(selMeme->GetName());

    // 自動取得特技
    // ToDo 初期特技点や経験点の計算
    //getAutoGottenTokugi(selMeme);
}

/**
from BranchWindow
ブランチ取得
*/
void OwnCoronaForm::GetSelectedBranch(Data *selBranch) //slot
{
    if(selBranch == NULL)
    {
	QMessageBox::warning(ui->tableWidget, "Warning", "何かブランチを選択してください",QMessageBox::Ok,QMessageBox::NoButton);
	return;
    }
    //_ownMeme = OwnMeme::GetInstance();

    // 選択ブランチが取得ブランチかチェック
    if(selBranch->IsOwned())
    {
	QMessageBox::warning(ui->tableWidget, "Warning", "取得済みのブランチです",QMessageBox::Ok,QMessageBox::NoButton);
	return;
    }

    // 異なっていた場合
    //選択ブランチのミームを取得しているかチェック
    try
    {
        if(!selBranch->GetParent()->IsOwned())
	{

            //取得していない場合
	    int ret = QMessageBox::question(ui->tableWidget, "Question", "このブランチの属するミームを取得していません\nついでに取得しますか？",QMessageBox::Ok | QMessageBox::Cancel,QMessageBox::NoButton);
            switch(ret)
	    {
	    case QMessageBox::Ok:
		{
                    //ミーム取得
                    GetSelectedMeme(selBranch->GetParent());
		    throw(0);
                    break;
                }
	    case QMessageBox::Cancel:
		break;
	    default:
		break;
	    }
	}
	else
	{
            throw(0);
	}
    }
    catch(int)
    {
        //ブランチ取得
	_ownBranch.append(selBranch);
        selBranch->GetParent()->OwnAdd(selBranch);

	addCategory(ui->tableWidget_4, selBranch);

	if(selBranch->GetParent() == _mainMeme)
	{
            ui->comboBox_2->addItem(selBranch->GetName());
	}

	// 自動取得特技
	getAutoGottenTokugi(selBranch);
    }

    return;
}

/**
 コロナ取り消しボタン
 */
void OwnCoronaForm::on_pushButton_clicked()
{
    if(ui->tableWidget->item(ui->tableWidget->currentRow(), 0)==NULL)
    {
	QMessageBox::warning(ui->tableWidget, tr("Warning"), tr("コロナを選択してください"),QMessageBox::Ok,QMessageBox::NoButton);
	return;
    }

    removeTokugi(_ownCorona.at(0));

    //取得コロナ除去
    emit removeCorona(_ownCorona.at(0));
    removeCategory(ui->tableWidget, _ownCorona, 0);
    _ownGeneral->OwnRemove(_ownCorona.takeFirst());
}

/**
  ミーム取り消しボタン
  */
void OwnCoronaForm::on_pushButton_3_clicked()
{
    int row = ui->tableWidget_3->currentRow();
    if(ui->tableWidget_3->item(row, 0)==NULL)
    {
	QMessageBox::warning(ui->tableWidget_3, tr("Warning"), tr("ミームを選択してください"),QMessageBox::Ok,QMessageBox::NoButton);
	return;
    }

    Data* selMeme = _ownMeme.at(row);
    //選択ミーム下の取得ブランチを欄から除去
    for(int i=0;i<_ownBranch.size();)
    {
	if(_ownBranch.at(i)->GetParent()==selMeme)
	{
	    ui->tableWidget_4->removeRow(i);

            emit removeBranch(_ownBranch.at(i));

            removeTokugi(_ownBranch.takeAt(i));
            continue;
	}
        ++i;
    }

    removeTokugi(selMeme);
    //選択ミーム除去
    emit removeMeme(selMeme);

    if(selMeme == _mainMeme)
    {
        ui->comboBox->setCurrentIndex(-1);
        ui->comboBox_2->clear();
        _mainMeme = NULL;
	_mainBranch = NULL;
    }
    ui->comboBox->removeItem(row);
    removeCategory(ui->tableWidget_3, _ownMeme, row);
    _ownGeneral->OwnRemove(_ownMeme.takeAt(row));
}

/**
  ブランチ取り消しボタン
  */
void OwnCoronaForm::on_pushButton_4_clicked()
{
    int row = ui->tableWidget_4->currentRow();
    if(ui->tableWidget_4->item(row, 0)==NULL)
    {
	QMessageBox::warning(ui->tableWidget_4, tr("Warning"), tr("ブランチを選択してください"),QMessageBox::Ok,QMessageBox::NoButton);
	return;
    }

    Data *selBranch = _ownBranch.at(row);
    removeTokugi(selBranch);

    //取得ブランチ除去
    if(selBranch->GetParent() == _mainMeme)
    {
        int i = 0;
        foreach(Data *branch, _ownBranch)
        {
            if(branch->GetParent() == _mainMeme)
            {
                if(branch == selBranch)
                {
                    ui->comboBox_2->removeItem(i);
                    break;
                }
                ++i;
            }
        }
    }
    removeBranch(selBranch);
    removeCategory(ui->tableWidget_4, _ownBranch, row);
    selBranch->GetParent()->OwnRemove(_ownBranch.takeAt(row));
}

/**
  特技取消ボタン
  */
void OwnCoronaForm::on_pushButton_2_clicked()
{
    int row = ui->tableWidget_2->currentRow();
    if( (row >= _ownTokugiList.size()) || (row < 0) )
    {
	QMessageBox::warning(ui->tableWidget_2, tr("Warning"), tr("特技の選択が不正です"), QMessageBox::Ok, QMessageBox::NoButton);
	return;
    }

    Data* od = _ownTokugiList.at(row);
    if( (od->GetName().contains("◆")) && (od->GetInitialLevel()==1) )
    {
	QMessageBox::warning(ui->tableWidget_2, tr("Warning"), tr("自動取得特技は取り消せません"));
	return;
    }
    od->DecreaseInitialLevel();

    // 取得特技を取り除く場合
    if(od->GetInitialLevel() == 0)
    {
	// delete　od 含む
	if(! od->GetParent()->OwnRemove(od) )
	{
	    QMessageBox::warning(ui->tableWidget_2, tr("Warning"), tr("特技の取消なんか失敗"),QMessageBox::Ok,QMessageBox::NoButton);
	    return;
	}
	_ownTokugiList.removeOne(od);
	ui->tableWidget_2->removeRow(row);

	// 行が無くなったなら
	if(ui->tableWidget_2->rowCount()==0)
	{
	    // 行を一つ増やす
            ui->tableWidget_2->setRowCount(1);
	}
    }
    // 取得特技のレベルを下げる場合
    else
    {
	// 特技名列検索
	int nameColumn = -1;
	for(int k=0;k < ui->tableWidget_2->columnCount();k++)
	{
	    if( ui->tableWidget_2->horizontalHeaderItem(k)->text().contains(QObject::tr("特技名")) )
	    {
		nameColumn = k;
		break;
	    }
	}

	if(nameColumn==-1)
	{
	    QMessageBox::warning(ui->tableWidget_2, QObject::tr("Warning"), QObject::tr("所属列が見つかりません"), QMessageBox::Ok, QMessageBox::NoButton);
	    return;
	}
        ui->tableWidget_2->setItem(ui->tableWidget_2->currentRow(), nameColumn, new QTableWidgetItem( od->GetName().append("[").append(QString::number( od->GetInitialLevel()) ).append("/").append(QString::number( od->GetInitialLevel() + od->GetExperimentalLevel()) ).append("]"), 0) );
    }
    //emit removeRowSignal(row);
}

/**
  取得コロナリスト取得
  */
QList<Data*> OwnCoronaForm::GetOwnCoronaList()
{
    return _ownCorona;
}

/**
  取得ミームリスト取得
  */
QList<Data*> OwnCoronaForm::GetOwnMemeList()
{
    return _ownMeme;
}

/**
  取得ブランチリスト取得
  */
QList<Data*> OwnCoronaForm::GetOwnBranchList()
{
    return _ownBranch;
}

/**
  取得特技リスト取得
  */
QList<Data*> OwnCoronaForm::GetOwnTokugiList()
{
    return _ownTokugiList;
}

/**
  メインミームセット
  */
Data* OwnCoronaForm::GetMainMeme()
{
    return _mainMeme;
}

/**
  メインブランチセット
  */
Data* OwnCoronaForm::GetMainBranch()
{
    return _mainBranch;
}

/**
  メインミーム選択コンボボックスでの選択
  */
void OwnCoronaForm::on_comboBox_currentIndexChanged(int index)
{
    if( (ui->comboBox->count() == 0) || (index < 0) )
    {
	return;
    }

    _mainMeme = _ownMeme.at(index);

    ui->comboBox_2->clear();
    if(_ownBranch.size()>0)
    {
        foreach(Data *b, _ownBranch)
        {
            if(b->GetParent() == _mainMeme)
            {
                ui->comboBox_2->addItem(b->GetName());
            }
        }
    }
}

/**
  メインブランチ選択コンボボックスでの選択
  */
void OwnCoronaForm::on_comboBox_2_currentIndexChanged(int index)
{
    if(ui->comboBox_2->count()==0)
    {
	return;
    }
    _mainBranch = _ownBranch.at(index);
}
/**
  リサイズイベント
  列リサイズ
  */
void OwnCoronaForm::resizeEvent(QResizeEvent *)
{
    ui->tableWidget_2->resizeColumnsToContents();
}

/**
  特技欄セルクリック
  列リサイズ
  */
void OwnCoronaForm::on_tableWidget_2_cellClicked(int row, int column)
{
    ui->tableWidget_2->resizeColumnToContents(column);
}
