#include "memewindow.h"
#include "ui_memewindow.h"
#include <QDebug>
#include <QMessageBox>
#include "meme.h"
#include "branch.h"

MemeWindow::MemeWindow(CategoryWindow *parent) :
    CategoryWindow(parent),
    ui(new Ui::MemeWindow),
    _memeList(),
    _memeTokugiTableWidget(),
    _branchList(),
    _branchTokugiTableWidget()
{
    ui->setupUi(this);
    _memeTokugiTableWidget = ui->MemeTokugiTableWidget;
    _branchTokugiTableWidget = ui->BranchTokugiTableWidget;
}

MemeWindow::~MemeWindow()
{
    delete ui;
}

void MemeWindow::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MemeWindow::resizeEvent(QResizeEvent *)
{
    ui->MemeTokugiTableWidget->resizeColumnsToContents();
    ui->BranchTokugiTableWidget->resizeColumnsToContents();
}

/**
  ミーム欄に選択されたdata以下の子ミームを表示
  */
bool MemeWindow::addMeme(Data * data)
{
    bool b = addCategory(ui->MemeTableWidget, data, _memeList, new Meme);
    foreach(Data *m, _memeList)
    {
        ui->verticalLayout_2->insertWidget(ui->verticalLayout_2->count() -1, m->getTokugiTableWidget() );
        m->getTokugiTableWidget()->hide();

        for(int i=0;m->GetChild(i)!=NULL;++i)
        {
            Data *branch = m->GetChild(i);
            if(branch->GetCategory()!=NULL)
            {
                ui->verticalLayout_3->insertWidget(ui->verticalLayout_3->count() -1, branch->getTokugiTableWidget() );
                branch->getTokugiTableWidget()->hide();
            }
        }
    }

    return b;
}

/**
 ブランチ欄に選択されたdata以下の子ブランチを表示
 */
bool MemeWindow::addBranch(Data * data)
{
    return addCategory(ui->BranchTableWidget, data, _branchList, new Branch);
}

bool MemeWindow::setTableResize()
{
    ui->MemeTableWidget->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    ui->MemeTokugiTableWidget->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    ui->BranchTableWidget->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    ui->BranchTokugiTableWidget->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    return true;
}

/**
  クリックされたミーム以下の特技をミーム特技欄に表示
  また、ブランチ欄にそのミーム以下のブランチを表示
  */
void MemeWindow::on_MemeTableWidget_clicked(QModelIndex index)
{
    _branchList.clear();
    _branchTokugiTableWidget->hide();
    _branchTokugiTableWidget = ui->BranchTokugiTableWidget;
    _branchTokugiTableWidget->show();

 //   _memeTokugiList = ShowTokugi(ui->MemeTableWidget, ui->MemeTokugiTableWidget, _memeList);
    addCategory(ui->BranchTableWidget, _memeList.at(ui->MemeTableWidget->currentRow()), _branchList, new Branch);

    _memeTokugiTableWidget->hide();
    _memeTokugiTableWidget = showTokugiTableWidget(_memeList.at(ui->MemeTableWidget->currentRow()) );
}

/**
  クリックされたブランチ以下の特技をブランチ特技欄に表示
  */
void MemeWindow::on_BranchTableWidget_clicked(QModelIndex index)
{
   // _branchTokugiList = ShowTokugi(ui->BranchTableWidget, ui->BranchTokugiTableWidget, _branchList);

    _branchTokugiTableWidget->hide();
    _branchTokugiTableWidget = showTokugiTableWidget(_branchList.at(ui->BranchTableWidget->currentRow()) );
}

/**
  * ミーム取得ボタン
  * 取得ミームを設定
  */
void MemeWindow::on_GetMemeButton_clicked()
{
    Data* selMeme = _memeList.at(ui->MemeTableWidget->currentRow());

    //to OwnCoronaForm::GetSelectedMeme
    //for displaying corona
    emit selectedMeme(selMeme);
    return;
}

/**
  * ブランチ取得ボタン
  * 取得ブランチを設定
  */
void MemeWindow::on_GetBranchButton_clicked()
{
    Data* selBranch = _branchList.at(ui->BranchTableWidget->currentRow());

    //to OwnCoronaForm::GetSelectedBranch
    //for displaying branch
    emit selectedBranch(selBranch);
}

/**
  * ミーム特技取得ボタン
  * 取得ミーム下に取得特技を追加する
  */
void MemeWindow::on_GetMemeTokugiButton_clicked()
{
    Data* gtokugi = getTokugi(ui->MemeTableWidget, _memeTokugiTableWidget, _memeList);

    if(gtokugi != NULL)
    {
        //ToOwnCoronaForm::GetSelecetedMemeTokugi
        emit selectedMemeTokugi(gtokugi);
    }
}

/**
  * ブランチ特技取得ボタンz
  * 取得ブランチ下に取得特技を追加する
  */
void MemeWindow::on_GetBranchTokugiButton_clicked()
{
    //to OwnCoronaForm::GetSelecetedMemeTokugi
    emit selectedBranchTokugi( getTokugi(ui->BranchTableWidget, _branchTokugiTableWidget, _branchList) );
    return;
}

void MemeWindow::on_MemeTokugiTableWidget_cellClicked(int row, int column)
{
    ui->MemeTokugiTableWidget->resizeColumnToContents(column);
}

void MemeWindow::on_BranchTokugiTableWidget_cellClicked(int row, int column)
{
    ui->BranchTokugiTableWidget->resizeColumnToContents(column);
}
