#include "memedatainterpreter.h"
#include <QMessageBox>

MemeDataInterpreter::MemeDataInterpreter()
    :_meme()
{
}

Data* MemeDataInterpreter::Interpret(QList<QString> list, Data *data)
{
    _meme = new Meme(list.takeFirst());

    QVector<int> vector;
    bool ok;

    for(int i=0;i<5;++i)
    {
        vector.append(list.value(i).toInt(&ok, 10));
    }

    _meme->SetKihonCapability(vector);
    data->Add(_meme);

    return _meme;
}

Data* MemeDataInterpreter::Interpret(QString str, Data * data)
{
    QRegExp memeRegExp("^#(.+)(/(\\d+/){5})");
    QRegExp capability5("/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/");

    if( memeRegExp.indexIn(str) <= -1)
    {
        return GoNext(str, data);
    }

    if( capability5.indexIn(memeRegExp.cap(2)) <= -1)
    {
        QMessageBox::warning(NULL, tr("Warning"), tr("ミームの能力値の記述が異常です"), QMessageBox::Ok, QMessageBox::NoButton);
        return NULL;
    }

    _meme = new Meme(memeRegExp.cap(1));

    QVector<int> vector;
    bool ok;

    for(int i=1;i<=5;i++)
    {
        vector.append(capability5.cap(i).toInt(&ok, 10));
    }
    /*
                   _meme->SetKihonCapability(vector);

                    vector.fill(0,5);
                    for(int i=6;i<=10;i++)
                    {
                        vector.append(capability.cap(i).toInt(&ok, 10));
                    }
                    */
    _meme->SetSentouCapability(vector);
    data->Add(_meme);

    return _meme;
}

