#include <QtGui/QApplication>
#include <QString>
#include <QDebug>
#include <QTextCodec>
#include <QMessageBox>

#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "coronawindow.h"
#include "memewindow.h"
#include "possibletokugiform.h"
#include "owncoronaform.h"
#include "category.h"
#include "filedatareader.h"

int main(int argc, char *argv[])
{
    QTextCodec::setCodecForTr(QTextCodec::codecForName("utf-8"));
    QTextCodec::setCodecForCStrings(QTextCodec::codecForName("utf-8"));
    QApplication a(argc, argv);

    //カテゴリ一般を作成。この下に特技やらコロナやらを入れる
    Category* general = new Category(QString("一般"));

    FileDataReader* dr = FileDataReader::GetInstance();
    if(! dr->Read(QString("Corona.txt"), general) )
    {
        QMessageBox msgBox;
        msgBox.critical(NULL, QObject::tr("Critical"), QObject::tr("Corona.txt 読み込み時のエラーで終了します") );
        return 0;
    }
    if(! dr->Read(QString("Meme.txt"), general) )
    {
        QMessageBox msgBox;
        msgBox.critical(NULL, QObject::tr("Critical"), QObject::tr("Meme.txt 読み込み時のエラーで終了します") );
        return 0;
    }

    CoronaWindow cw;
    cw.setWindowTitle("コロナ");
    cw.setGeneral(general);
    cw.addCorona(general);
    cw.setTableResize();
    cw.setAttribute(Qt::WA_QuitOnClose, false);
    //cw.show();

    MemeWindow mw;
    mw.setWindowTitle("ミーム");
    mw.setGeneral(general);
    mw.addMeme(general);
    mw.setTableResize();
    mw.setAttribute(Qt::WA_QuitOnClose, false);
    //mw.show();

    PossibleTokugiForm ptf;
    ptf.setWindowTitle("取得可能特技");
    ptf.setTableResize();
    ptf.addTokugi(general);
    ptf.setAttribute(Qt::WA_QuitOnClose, false);
    //ptf.show();

    OwnCoronaForm ocf;
    ocf.setWindowTitle("取得コロナ・ミーム・ブランチ・特技");
    ocf.setOwnGeneral(general);
    ocf.setTableResize();
    ocf.setAttribute(Qt::WA_QuitOnClose, false);
    //ocf.show();

    MainWindow w;
    w.setWindowTitle("cf_chara_maker");
    w.setGeneral(general);
    w.setCoronaWindow(&cw);
    w.setMemeWindow(&mw);
    w.setOwnCoronaForm(&ocf);
    w.setPossibleTokugiForm(&ptf);
    //w.setAttribute(Qt::WA_DeleteOnClose, true); //ニ回デストラクタが呼ばれてしまう。
    //QObject::connect(&w, SIGNAL(destroyed(QObject*)), &a, SLOT(quit()));
    w.show();

    QObject::connect( &cw, SIGNAL(selectedCorona(Data*)), &ocf, SLOT(GetSelectedCorona(Data*)));
    QObject::connect( &cw, SIGNAL(selectedCoronaTokugi(Data*) ), &ocf, SLOT( GetSelectedCoronaTokugi(Data*) ) );

    QObject::connect( &mw, SIGNAL(selectedMeme(Data*)), &ocf, SLOT(GetSelectedMeme(Data*)));
    QObject::connect( &mw, SIGNAL(selectedBranch(Data*)), &ocf, SLOT(GetSelectedBranch(Data*)));
    QObject::connect( &mw, SIGNAL(selectedMemeTokugi(Data*) ), &ocf, SLOT( GetSelectedMemeTokugi(Data*) ) );
    QObject::connect( &mw, SIGNAL(selectedBranchTokugi(Data*) ), &ocf, SLOT( GetSelectedMemeTokugi(Data*) ) );

    QObject::connect( &cw, SIGNAL(selectedCorona(Data*)), &ptf, SLOT(GetSelectedCorona(Data*)));
    QObject::connect( &mw, SIGNAL(selectedMeme(Data*)), &ptf, SLOT(GetSelectedMeme(Data*)));
    QObject::connect( &mw, SIGNAL(selectedBranch(Data*)), &ptf, SLOT(GetSelectedBranch(Data*)));

    QObject::connect( &ptf, SIGNAL(selectedTokugi(Data*)), &ocf, SLOT(GetSelectedCoronaTokugi(Data*)));

    QObject::connect( &ocf, SIGNAL(removeCorona(Data*)), &ptf, SLOT(getRemovedCategory(Data*)));
    QObject::connect( &ocf, SIGNAL(removeMeme(Data*)), &ptf, SLOT(getRemovedCategory(Data*)));
    QObject::connect( &ocf, SIGNAL(removeBranch(Data*)), &ptf, SLOT(getRemovedCategory(Data*)));

    QObject::connect( &w, SIGNAL(applicationExit()), &a, SLOT(quit()) );
    return a.exec();
}
